
// Hier chartName und chartTitle anpassen, chartName muss übereinstimmen mit der canvas-id in der index.html
// edit chartName and chartTitle, chartName must match canvas-id in index.html
var chartName = '_yearBar';
var chartTitle = 'Temperaturverlauf in °C - Balken';

var ctx = document.getElementById(chartName).getContext('2d');
var chartjs = new Chart(ctx, {
	type: 'bar',
	data: 
	{
		labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
		datasets: 
		[
			{
				label: 'max',
				data: [5, 4, 16, 22, 24, 23, 29, 38, 32, 22, 18, 8],
				backgroundColor: '#c99',
				borderColor: '#c99',
				borderWidth: 1,
				pointBorderWidth: 2,
				fill: true
			},
			{
				label: 'mittel',
				data: [1, -2, 8, 12, 16, 14, 18, 26, 23, 16, 9, 3],
				backgroundColor: '#c50',
				borderColor: '#c50',
				borderWidth: 1,
				pointBorderWidth: 2,
				fill: true
			},
			{
				label: 'min',
				data: [-12, -15, -6, 2, 5, 3, 12, 18, 14, 6, -2, -6],
				backgroundColor: '#69c',
				borderColor: '#69c',
				borderWidth: 1,
				pointBorderWidth: 2,
				fill: true
			}
		]
	},
	options: 
	{
		title: {display: true, text: chartTitle, fontSize: '15', fontColor: '#333'},
		legend: 
		{
			display: true,
			position: 'bottom',
			labels: {fontColor: '#666', boxWidth: 24}
		},
		scales: 
		{
			xAxes: 
			[
				{
					ticks: {fontColor: '#333'}
				}
			],
			yAxes: 
			[
				{
					ticks: {fontColor: '#333', beginAtZero: true}
				}
			]
		}
	}
});