
// Hier chartName und chartTitle anpassen, chartName muss übereinstimmen mit der canvas-id in der index.html
// edit chartName and chartTitle, chartName must match canvas-id in index.html
var chartName = '_weekLine';
var chartTitle = 'Eine Woche im April - Kurven';

var ctx = document.getElementById(chartName).getContext('2d');
var chartjs = new Chart(ctx, {
	type: 'line',
	data: 
	{
		labels: ['Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa', 'So'],
		datasets: 
		[
			{
				label: 'Sonnenschein [h]',
				data: [4, 5, 1, 5, 4, 7, 2.5],
//				backgroundColor: '',
				borderColor: '#f90',
				borderWidth: 1,
				pointBorderWidth: 1,
				fill: false
			},
			{
				label: 'Regen [h]',
				data: [3, 6, 2.5, 1.5, 5, 3, 1],
//				backgroundColor: '',
				borderColor: '#09c',
				borderWidth: 1,
				pointBorderWidth: 1,
				fill: false
			}
		]
	},
	options: 
	{
		title: {display: true, text: chartTitle, fontSize: '15', fontColor: '#333'},
		legend: 
		{
			display: true,
			position: 'bottom',
			labels: {fontColor: '#666', boxWidth: 24}
		},
		scales: 
		{
			xAxes: 
			[
				{
					ticks: {fontColor: '#333'}
				}
			],
			yAxes: 
			[
				{
					scaleLabel: {display: true, labelString: 'Stunden', fontColor: '#333'},
					ticks: {fontColor: '#333', beginAtZero: true}
				}
			]
		}
	}
});