
// Hier chartName und chartTitle anpassen, chartName muss übereinstimmen mit der canvas-id in der index.html
// edit chartName and chartTitle, chartName must match canvas-id in index.html
var chartName = '_stackLine';
var chartTitle = 'Downloads - Kurven gestapelt';

var ctx = document.getElementById(chartName).getContext('2d');
var chartjs = new Chart(ctx, {
	type: 'line',
	data: 
	{
		labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
		datasets: 
		[
			{
				label: 'System',
				data: [684, 856, 796, 438, 516, 593, 490, 456, 930, 767, 564, 597],
//				backgroundColor: '#046',
				borderColor: '#046',
				borderWidth: 1,
				pointBorderWidth: 1,
				fill: true
			},
			{
				label: 'Update',
				data: [327, 822, 489, 192, 140, 98, 127, 126, 962, 723, 134, 164],
//				backgroundColor: '#39c',
				borderColor: '#096',
				borderWidth: 1,
				pointBorderWidth: 1,
				fill: true
			}
		]
	},
	options: 
	{
		title: {display: true, text: chartTitle, fontSize: '15', fontColor: '#333'},
		legend: 
		{
			display: true,
			position: 'bottom',
			labels: {fontColor: '#666', boxWidth: 24}
		},
		scales: 
		{
			xAxes: 
			[
				{
					stacked: true,
					ticks: {fontColor: '#333'}
				}
			],
			yAxes: 
			[
				{
					stacked: true,
					ticks: {fontColor: '#333', beginAtZero: true}
				}
			]
		}
	}
});