<?php // utf-8 check: äöü

if (!function_exists('sv') || preg_match('#plugins/charts/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin Charts
============================================================
Version:    Charts 2.2
Released:   2023-01
Copyright:  Gert Ebersbach
Internet:   www.ge-webdesign.de
Credit:     chartjs script - chartjs.org
============================================================ 
License: Commercial License (for commercial websites only)
see http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen
============================================================ 
*/

if(file_exists('./plugins/charts/source/Chart.bundle.min.js'))
{
	$basepathChartsSource = './';
}
else
{
	$basepathChartsSource = $pth['folder']['base'];
}





/* 
################################
       Chart Funktion
################################ 
*/

function simpleChart($chartName = 'nodata')
{
global $pth, $plugin_cf, $plugin_tx, $hjs, $basepathChartsSource;

if(isset($hjs))
{
	if(!stristr($hjs,'Chart.bundle.min.js')) $hjs.='<script src="' . $basepathChartsSource . 'plugins/charts/source/Chart.bundle.min.js"></script>
';
}
else
{
	if(!stristr($hjs,'Chart.bundle.min.js')) $hjs ='<script src="' . $basepathChartsSource . 'plugins/charts/source/Chart.bundle.min.js"></script>
';
}

if(is_dir('./content/plugins/charts/'))
{
	$pathDataFile = $plugin_cf['charts']['path_charts'] . $chartName . '.php';
}
else
{
	$pathDataFile = $pth['folder']['base'] . $plugin_cf['charts']['path_charts'] . $chartName . '.php';
}


/* default data and settings */

$chartsOptionsContainerCSS = 'box-sizing: border-box; max-width: 480px; margin: 16px auto 24px auto;';
$chartsOptionsTitleCSS = 'font-weight: 700; text-align: center; padding: 6px 16px 16px 16px;';

$chartsChartTitle = 'Chart Title';
$chartsOptionsChartHeight = '8';
$chartsChartType = 'bar';

$chartsLables = '"1. Quartal","2. Quartal","3. Quartal","4. Quartal"';
$chartsDatasetsData = '"1.3","-0.8","2.7","2.2"';
$chartsDatasetsUnit = ' Wachstum zum Vorjahr in %';
$chartsDatasetsDataColors = '"#096","#c00","#096","#096"';
$chartsDatasetsBorderColor = '#fff';
$chartsDatasetsFontColor = '#333';
$chartsDatasetsBorderWidth = '0';
$chartsDatasetsPointBorderWidth = '5';
$chartsDatasetsFill = 'false';

$chartsOptionsDisplayLegend = 'false';
$chartsOptionsShowTooltips = 'true';
$chartsOptionsDisplayXaxis = 'true';
$chartsOptionsDisplayGridlinesX = 'true';
$chartsOptionsDisplayYaxis = 'true';
$chartsOptionsDisplayGridlinesY = 'true';
$chartsOptionsYaxisFromZero = 'true';



/* includes data file, if exists */
/* the data file overwrites default data and settings */
if(file_exists($pathDataFile))include($pathDataFile);

$output = '
<div style="' . $chartsOptionsContainerCSS . '">
<p style="' . $chartsOptionsTitleCSS . '">' . $chartsChartTitle . '</p>
<canvas id="' . $chartName . '" width="10" height="' . $chartsOptionsChartHeight . '"></canvas>
<script>// <![CDATA[
var ctx = document.getElementById("' . $chartName . '");
var ' . $chartName . ' = new Chart(ctx, 
{
	type: "' . $chartsChartType . '",
	data: 
	{
		labels: [' . $chartsLables . '],
		datasets: 
		[
			{
				label: "' . $chartsDatasetsUnit . '",
				data: [' . $chartsDatasetsData . '],
				backgroundColor: [' . $chartsDatasetsDataColors . '],
				borderColor: "' . $chartsDatasetsBorderColor . '",
				borderWidth: "' . $chartsDatasetsBorderWidth . '",
				pointBorderWidth: "' . $chartsDatasetsPointBorderWidth . '",
				fill: ' . $chartsDatasetsFill . '
			}
		]
	},
	options: 
	{
		legend: 
		{
			display: ' . $chartsOptionsDisplayLegend . ',
			labels: {fontColor: "' . $chartsDatasetsFontColor . '"}
		},
		tooltips: {enabled: ' . $chartsOptionsShowTooltips . '},
		scales: 
		{
			xAxes: 
			[
				{
					display: ' . $chartsOptionsDisplayXaxis . ',
					gridLines: {drawOnChartArea: ' . $chartsOptionsDisplayGridlinesX . '},
					ticks: {fontColor: "' . $chartsDatasetsFontColor . '"}
				}
			],
			yAxes: 
			[
				{
					display: ' . $chartsOptionsDisplayYaxis . ',
					gridLines: {drawOnChartArea: ' . $chartsOptionsDisplayGridlinesY . '},
					ticks: 
					{
						beginAtZero: ' . $chartsOptionsYaxisFromZero . ',
						fontColor: "' . $chartsDatasetsFontColor . '"
					}
				}
			]
		}
	}
}
);
// ]]></script>
<noscript style="display: table; background: #eee; color: #333; border: 3px solid #999; border-radius: 3px; padding: 16px 24px; margin: 0 auto 16px auto;">
' . $plugin_tx['charts']['message_noscript'] . '
</noscript>
</div>
';

return $output;
}



function cjsChart($chartName = 'nodata'){return simpleChart($chartName);}



function chartJS($chartName = 'nodata', $relHeight = '8', $chartMaxWidth = '900px', $chartMinWidth = '240px')
{
global $pth, $plugin_cf, $plugin_tx, $hjs, $basepathChartsSource;

if(isset($hjs))
{
	if(!stristr($hjs,'Chart.bundle.min.js')) $hjs.='<script src="' . $basepathChartsSource . 'plugins/charts/source/Chart.bundle.min.js"></script>
';
}
else
{
	if(!stristr($hjs,'Chart.bundle.min.js')) $hjs ='<script src="' . $basepathChartsSource . 'plugins/charts/source/Chart.bundle.min.js"></script>
';
}

if(is_dir('./userfiles/plugins/charts/'))
{
$pathDataFile = './userfiles/plugins/charts/' . $chartName . '.js';
}
else
{
	$pathDataFile = $pth['folder']['base'] . 'userfiles/plugins/charts/' . $chartName . '.js';
}

$output = '
<div style="min-width: ' . $chartMinWidth . '; max-width: ' . $chartMaxWidth . '; margin: 20px auto;">
<canvas id="' . $chartName . '" width="10" height="' . $relHeight . '"></canvas>
<script src="./userfiles/plugins/charts/' . $chartName . '.js"></script>
<noscript style="display: table; background: #eee; color: #333; border: 3px solid #999; border-radius: 3px; padding: 16px 24px; margin: 0 auto 16px auto;">
' . $plugin_tx['charts']['message_noscript'] . '
</noscript>
</div>
';

return $output;
}
?>