<?php

/*
============================================================
CMSimple Plugin MailForms 
Based on "Secure PHP Form Mailer Script" from dagondesign.com (2009)
============================================================
Version:    MailForms 2.11
Released:   2025-01
Copyright:  Gert Ebersbach - www.ge-webdesign.de 
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
utf-8 check: äöü 
*/

/*
Based on Dagon Design Form Mailer  Version 5.8 
released 2009
dagondesign.com/articles/secure-php-form-mailer-script/

adapted for CMSimple Plugin MailForms 2.6
updated for php 8.1.11
released 11/2022
ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins/MailForms

utf-8 check: äöü 
*/

// START OF OPTIONS

if(!isset($_SESSION)){session_start();}

global $sn, $u, $s, $pth, $plugin_cf, $plugin_tx, $tx, $recipients, $ddmfMailAdress;

$language = 'lang/CMSimple.php';
$script_path = $pth['folder']['base'] . 'plugins/mailforms/dd-formmailer.php';
$path_contact_page = $sn . "?" . str_replace('&amp;','&',htmlspecialchars(strip_tags($_SERVER['QUERY_STRING']), ENT_QUOTES, 'UTF-8')) . "#ddfmFormmail";
$path_contact_page = str_replace('&ddfmFormSent','',$path_contact_page);
$path_contact_page_sent = $sn . "?" . str_replace('&amp;','&',htmlspecialchars(strip_tags($_SERVER['QUERY_STRING']), ENT_QUOTES, 'UTF-8')) . "&ddfmFormSent#ddfmFormmailSent";
$wrap_messages = TRUE; // If enabled, this wraps messages to 70 chars per line (for RFC compliance)
$attach_save = FALSE; // If enabled, attachments will be saved to a directory instead of emailed
$attach_path = ''; // SAVE ATTACHMENT PATH (Where files will be saved, if attach_save is enabled, full path on server. Ex: /home/user/public_html/upload/
$show_required = TRUE; // If enabled, required fields are marked with an asterisk
$show_url = FALSE; // If enabled, the URL the script is running from will be added to the message
$show_ip_hostname = false; // If enabled, the visitor's IP and hostname are added to the message

$sender_name = $plugin_tx['mailforms']['admin_mailheader_from'];
$sender_email = 'ddmf_sender_email';

if(!isset($ddmfSubject) || $ddmfSubject == '')
{
	$email_subject = $plugin_tx['mailforms']['admin_mailheader_subject'] . ' ' . $_SERVER['SERVER_NAME'] . $sn;
}
else
{
	$email_subject = $ddmfSubject;
}

$max_file_size = $plugin_cf['mailforms']['upload_max_filesize']; // in bytes
$message_structure = '';
$sent_message = '<br id="ddfmFormmailSent"><p class="ddmfMailSent">' . $plugin_tx['mailforms']['frontend_email_sent'] . '</p>';

$auto_reply_name = '';
$auto_reply_email = '';
$auto_reply_subject = '';
$auto_reply_message = '';

// IMAGE VERIFICATION
// You can disable image verification, use the simple built-in method, or use ReCaptcha
// If you use ReCaptcha, sign up for a free account at http://recaptcha.net and enter the codes below

$verify_method = 'basic'; // 'off', 'basic', or 'recaptcha'

// RECAPTCHA IMAGE VERIFICATION OPTIONS
// Public and private keys - you get these when you sign up an account at http://recaptcha.net

$re_public_key = '';
$re_private_key = '';

// SAVE DATA TO FILE
// If set to TRUE, the form input will be saved in a delimited file

$save_to_file = FALSE;

// STILL SEND EMAIL
// If saving the data to a file, still have the script send the email?

$save_email = TRUE;

// DATA PATH
// The file that will be written to - make sure it has write access

$save_path = 'data.txt';

// DELIMITER
// Fields will be separated by this character. If this character is found in
// the actual data, it will be removed.

$save_delimiter = '|';

// NEWLINES
// Newlines in the data will be replaced by this

$save_newlines = "<br>";

// TIMESTAMP
// Add date/time to the beginning of each line 
// Uses the PHP date format: http://us.php.net/date
// Leave blank to disable this feature

$save_timestamp = "Y-m-d h:i:s A";

/*
** END OF OPTIONS 
*/



// End Of Line for mails
if ($plugin_cf['mailforms']['end_of_line'] == 'rn') define ('MF_LE', "\r\n");
elseif ($plugin_cf['mailforms']['end_of_line'] == 'n') define ('MF_LE', "\n");
elseif ($plugin_cf['mailforms']['end_of_line'] == 'r') define ('MF_LE', "\r");
else define ('MF_LE', "\r\n");

if (trim($path_contact_page) == '') 
{
	$path_contact_page = $script_path;
}

$verify_method = strtolower($verify_method);


/* Convert hex color code to R, G, B */
function ddfm_hex_to_rgb($h) 
{
	$h = trim($h, "#");
	$color = array();	
	if (strlen($h) == 6) 
	{
		$color[] = (int)hexdec(substr($h, 0, 2));
		$color[] = (int)hexdec(substr($h, 2, 2));
		$color[] = (int)hexdec(substr($h, 4, 2));
	} 
	elseif (strlen($h) == 3) 
	{
		$color[] = (int)hexdec(substr($h, 0, 1) . substr($h, 0, 1));
		$color[] = (int)hexdec(substr($h, 1, 1) . substr($h, 1, 1));
		$color[] = (int)hexdec(substr($h, 2, 1) . substr($h, 2, 1));
	}
	return $color;
}

// Generate verification code

$this_domain = preg_replace("/^www\./", "", $_SERVER['HTTP_HOST']);
srand(intval((double)microtime()*1000000));
for ($ddfmcode = '', $i = 0, $z = strlen($a = 'ABCDEFGHKLMNPRSTUWXYZ123456789')-1; $i != 5; $x = rand(0,$z), $ddfmcode.= $a[$x], $i++); 
$_SESSION['ddfmcode'] = $ddfmcode;
setcookie("ddfmcode", md5($ddfmcode), time()+3600, '/');


// Load language settings
include_once($language);

/* Check for GD support */
function ddfm_check_gd_support() 
{
	if (extension_loaded("gd") && (function_exists("imagegif") || function_exists("imagepng") || function_exists("imagejpeg"))) 
	{
		return TRUE;
	} 
	else 
	{
		return FALSE;
	}
}

/* Safe str_replace */
function ddfm_str_replace($search, $replace, $subject) 
{
	if(is_string($search) && is_array($replace)) $replace = implode(', ',$replace);
	if (isset($search)) 
	{
		return str_replace($search, $replace, $subject);
	} 
	else 
	{
		return $subject;
	}
}

/* Check for valid URL */
function ddfm_is_valid_url($link) 
{
	return(true);
}


/* Check for valid email address */
function dd_is_valid_email($email) 
{
	$validator = new EmailAddressValidator;
	if ($validator->check_email_address($email)) 
	{
		return TRUE;
	} 
	else 
	{
		return FALSE;
	}
} 

    /*
        EmailAddressValidator Class
        http://code.google.com/p/php-email-address-validation/

        Released under New BSD license
        http://www.opensource.org/licenses/bsd-license.php
    */

class EmailAddressValidator 
{
	/**
	 * Check email address validity
	 * @param   strEmailAddress     Email address to be checked
	 * @return  True if email is valid, false if not
	 */
	function check_email_address($strEmailAddress) 
	{
		
		// If magic quotes is "on", email addresses with quote marks will
		// fail validation because of added escape characters. Uncommenting
		// the next three lines will allow for this issue.
		//if (get_magic_quotes_gpc()) { 
		//    $strEmailAddress = stripslashes($strEmailAddress); 
		//}

		// Control characters are not allowed
		
		// CMSimple outcommented
		// if (preg_match('/[\x00-\x1F\x7F-\xFF]/', $strEmailAddress)) {
		//    return false;
		//}

		// Split it into sections using last instance of "@"
		$intAtSymbol = strrpos($strEmailAddress, '@');
		if ($intAtSymbol === false) 
		{
			// No "@" symbol in email.
			return false;
		}
		$arrEmailAddress[0] = substr($strEmailAddress, 0, $intAtSymbol);
		$arrEmailAddress[1] = substr($strEmailAddress, $intAtSymbol + 1);

		// Count the "@" symbols. Only one is allowed, except where 
		// contained in quote marks in the local part. Quickest way to
		// check this is to remove anything in quotes.
		$arrTempAddress[0] = preg_replace('/"[^"]+"/','',$arrEmailAddress[0]);
		$arrTempAddress[1] = $arrEmailAddress[1];
		$strTempAddress = $arrTempAddress[0] . $arrTempAddress[1];
		// Then check - should be no "@" symbols.
		if (strrpos($strTempAddress, '@') !== false) 
		{
			// "@" symbol found
			return false;
		}

		// Check local portion
		if (!$this->check_local_portion($arrEmailAddress[0])) 
		{
			return false;
		}

		// Check domain portion
		if (!$this->check_domain_portion($arrEmailAddress[1])) 
		{
			return false;
		}

		// If we're still here, all checks above passed. Email is valid.
		return true;

	}

	/**
	 * Checks email section before "@" symbol for validity
	 * @param   strLocalPortion     Text to be checked
	 * @return  True if local portion is valid, false if not
	 */
	 function check_local_portion($strLocalPortion) 
	 {
		// Local portion can only be from 1 to 64 characters, inclusive.
		// Please note that servers are encouraged to accept longer local
		// parts than 64 characters.
		if (!$this->check_text_length($strLocalPortion, 1, 64)) 
		{
			return false;
		}
		// Local portion must be:
		// 1) a dot-atom (strings separated by periods)
		// 2) a quoted string
		// 3) an obsolete format string (combination of the above)
		$arrLocalPortion = explode('.', $strLocalPortion);
		for ($i = 0, $max = sizeof($arrLocalPortion); $i < $max; $i++) 
		{
			if (!preg_match('.^('
							.    '([A-Za-z0-9!#$%&\'*+/=?^_`{|}~-]' 
							.    '[A-Za-z0-9!#$%&\'*+/=?^_`{|}~-]{0,63})'
							.'|'
							.    '("[^\\\"]{0,62}")'
							.')$.'
							,$arrLocalPortion[$i])) 
			{
				return false;
			}
		}
		return true;
	}

	/**
	 * Checks email section after "@" symbol for validity
	 * @param   strDomainPortion     Text to be checked
	 * @return  True if domain portion is valid, false if not
	 */
	function check_domain_portion($strDomainPortion) 
	{
		// Total domain can only be from 1 to 255 characters, inclusive
		if (!$this->check_text_length($strDomainPortion, 1, 255)) 
		{
			return false;
		}
		// Check if domain is IP, possibly enclosed in square brackets.
		if (preg_match('/^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])'
		   .'(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}$/'
		   ,$strDomainPortion) || 
			preg_match('/^\[(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])'
		   .'(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}\]$/'
		   ,$strDomainPortion)) 
		{
			return true;
		} 
		else 
		{
			$arrDomainPortion = explode('.', $strDomainPortion);
			if (sizeof($arrDomainPortion) < 2) 
			{
				return false; // Not enough parts to domain
			}
			for ($i = 0, $max = sizeof($arrDomainPortion); $i < $max; $i++) 
			{
				// Each portion must be between 1 and 63 characters, inclusive
				if (!$this->check_text_length($arrDomainPortion[$i], 1, 63)) 
				{
					return false;
				}
				
				// CMSimple outcommented
				//if (!preg_match('/^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|'
				//   .'([A-Za-z0-9]+))$/', $arrDomainPortion[$i])) {
				//    return false;
				//}
			}
		}
		return true;
	}

	/**
	 * Check given text length is between defined bounds
	 * @param   strText     Text to be checked
	 * @param   intMinimum  Minimum acceptable length
	 * @param   intMaximum  Maximum acceptable length
	 * @return  True if string is within bounds (inclusive), false if not
	 */
	function check_text_length($strText, $intMinimum, $intMaximum) 
	{
		// Minimum and maximum are both inclusive
		$intTextLength = strlen($strText);
		if (($intTextLength < $intMinimum) || ($intTextLength > $intMaximum)) 
		{
			return false;
		} 
		else 
		{
			return true;
		}
	}
}



/* Check for injection characters */
function ddfm_injection_chars($s) 
{
	return (preg_match("/\r/i", $s) || preg_match("/\n/i", $s) || preg_match("/%0a/i", $s) || preg_match("/%0d/i", $s)) ? TRUE : FALSE;
}

/* Make output safe for the browser */
function ddfm_bsafe($input) 
{
	return htmlspecialchars(stripslashes($input));
}


function ddfm_stripslashes($s) 
{
	if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc())
	{
		return stripslashes($s);
	}
	else 
	{
		return $s;
	}
}


function ddfm_injection_test($str) 
{ 
	$tests = array("/bcc\:/i", "/Content\-Type\:/i", "/Mime\-Version\:/i", "/cc\:/i", "/from\:/i", "/to\:/i", "/Content\-Transfer\-Encoding\:/i"); 
	return preg_replace($tests, "", $str); 
} 


function ddfm_send_mail($recipients, $sender_name, $sender_email, $email_subject, $email_msg, $attach_save, $attach_path, $attachments = false) 
{
	global $ddmfCopyToSender, $plugin_cf;
	
	$ddfm_email_from = $plugin_cf['mailforms']['admin_mail_adress'];
	
	$extra_recips = '';

	// generate recipient data from list
	if (strpos($recipients, '|')) 
	{
		$rdata = array();
		$ri = 0;
		$rtmp = explode('|', $recipients);
		foreach ($rtmp as $rd) 
		{
			if (trim($rd) != "") 
			{
				list($m, $e) = (array)explode("=", trim($rd), 2);
				$rdata[$ri]['m'] = trim(strtolower($m));
				$rdata[$ri]['e'] = trim($e);
				$ri++;
			}
		}

		rsort($rdata);

		$r_to = array();
		$extra_recips = "";
		foreach ($rdata as $r) 
		{ 
			if ($r['m'] == 'to') $r_to[] = $r['e'];	
			if ($r['m'] == 'cc') $extra_recips .= 'cc: ' . $r['e'] . MF_LE;
			if ($r['m'] == 'bcc') $extra_recips .= 'bcc: ' . $r['e'] . MF_LE;
		}
		$send_to = implode(', ', $r_to);
		
		if($ddmfCopyToSender == 'true')
		{
			$send_to.= ', ' . $sender_email;
		}
	} 
	else 
	{
		$send_to = trim($recipients);
		
		if($ddmfCopyToSender == 'true')
		{
			$send_to.= ', ' . $sender_email;
		}
	}


	$sender_name = ddfm_injection_test($sender_name);
	$sender_email = ddfm_injection_test($sender_email);
	$email_subject = ddfm_injection_test($email_subject);
	
	if (function_exists('mb_encode_mimeheader')) 
	{
		$email_subject = mb_encode_mimeheader($email_subject, 'UTF-8', 'Q', '');
		$sender_name = mb_encode_mimeheader($sender_name, 'UTF-8', 'Q', '');
	}


	if (trim($sender_name) == "") 
	{
		$sender_name = 'Anonymous';
	}
	if (trim($sender_email) == "") {
		$sender_email = 'user@domain.com';
	}
	if (trim($email_subject) == "") 
	{
		$email_subject = 'Contact Form';
	}


	$mime_boundary = md5(time()); 

	$headers = '';
	$msg = '';


	$headers .= 'From: ' . $sender_name . ' <' . $ddfm_email_from . '>' . MF_LE;
	$headers .= $extra_recips;
	$headers .= 'Reply-To: ' . $sender_name . ' <' . $sender_email . '>' . MF_LE;
	$headers .= 'Return-Path: ' . $sender_name . ' <' . $sender_email . '>' . MF_LE;
	$headers .= "Message-ID: <" . time() . "ddfm@" . $_SERVER['SERVER_NAME'] . ">" . MF_LE;
	$headers .= 'X-Sender-IP: ' . $_SERVER["REMOTE_ADDR"] . MF_LE;
	$headers .= "X-Mailer: PHP v" . phpversion() . MF_LE;

	$headers .= 'MIME-Version: 1.0' . MF_LE;
//	$headers .= 'Content-Type: multipart/related; boundary="' . $mime_boundary . '"';
	$headers .= 'Content-Type: multipart/mixed; boundary="' . $mime_boundary . '"';

	$msg .= '--' . $mime_boundary . MF_LE;
	$msg .= 'Content-Type: text/plain; charset="utf-8"' . MF_LE;
	$msg .= 'Content-Transfer-Encoding: 8bit' . MF_LE . MF_LE;

	$msg .= $email_msg . MF_LE . MF_LE;

	if (count($attachments) > 0) 
	{
		for ($i = 0; $i < count($attachments); $i++) 
		{ 
			if (is_file($attachments[$i]['tmpfile'])) 
			{
				if ($attach_save) 
				{
					if (!rename($attachments[$i]['tmpfile'], $attach_path . $attachments[$i]['file'])) 
					{
						echo 'Error saving file. Check your path and permissions. Stopping script.';
						exit();
					}
				} 
				else 
				{
					$handle = fopen($attachments[$i]['tmpfile'], 'rb');
					$f_contents = fread($handle, filesize($attachments[$i]['tmpfile'])); 
					$f_contents = chunk_split(base64_encode($f_contents));
					fclose($handle);

					$msg .= '--' . $mime_boundary . MF_LE;
					$msg .= 'Content-Type: application/octet-stream; name="' . $attachments[$i]['file'] . '"' . MF_LE;
					$msg .= 'Content-Transfer-Encoding: base64' . MF_LE;
					$msg .= 'Content-Disposition: attachment; filename="' . $attachments[$i]['file'] . '"' . MF_LE . MF_LE; 
					$msg .= $f_contents . MF_LE . MF_LE;
				}
			}
		}
	}

	$msg .= '--' . $mime_boundary . '--' . MF_LE . MF_LE;

	ini_set('sendmail_from', $sender_email);
	if
	(
		!isset($_POST['ddmf_sender_phone_hpt']) || (isset($_POST['ddmf_sender_phone_hpt']) && $_POST['ddmf_sender_phone_hpt'] == '')
	)
	{
		$send_status = mail($send_to, $email_subject, $msg, $headers); 
	}
	else 
	{
		$send_status = 'nix';
	}
	ini_restore('sendmail_from');

	return $send_status;
}

$form_input = array();


// START of functions to show form output

function ddfm_gen_html($item) 
{
	// type=html|text=
	$gen = $item['text'] . "\n";
	return $gen;
}


function ddfm_gen_date($item) 
{
	// type=date|class=|label=|fieldname=|req=(TRUEFALSE)

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && ($item['req'] == 'true')) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '">' . $req_text . $item['label'] . '</label>';
	$gen .= '<input class="' . $item['class'] . '" type="text" name="' . $item['fieldname'] . '" id="' . $item['fieldname'] . '" value="';

	if ($form_submitted) 
	{
		$gen .= ddfm_bsafe($form_input[$item['fieldname']]);
	} 
	elseif (isset($item['default'])) 
	{
		$gen .= ddfm_bsafe($item['default']);
	}

	$gen .= '">';

	global $script_path;

	$i = strrpos($script_path, "/");
	$tmp_path = substr($script_path, 0, $i);
	
	// $gen .= '<input type="button" value="select" onclick="displayDatePicker(\'' . $item['fieldname'] . '\', this);">';
	$gen .= '<img src="' . rtrim($tmp_path, '/') . '/images/calendar.gif" alt=""  onclick="displayDatePicker(\'' . $item['fieldname'] . '\', this);">';
	$gen .='</p>' . "\n\n";
	return $gen;
}



function ddfm_gen_text($item) 
{
	// type=text|class=|label=|fieldname=|max=|req=(TRUEFALSE)|[ver=]|[default=]

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && ($item['req'] == 'true')) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '">' . $req_text . $item['label'] . '</label>';
	$gen .= '<input class="' . $item['class'] . '" type="text" name="' . $item['fieldname'] . '" id="' . $item['fieldname'] . '" value="';

	if ($form_submitted) 
	{
		$gen .= ddfm_bsafe($form_input[$item['fieldname']]);
	} 
	elseif (isset($item['default'])) 
	{
		$gen .= ddfm_bsafe($item['default']);
	}
	$gen .= '"></p>' . "\n";
	return $gen;
}


function ddfm_gen_password($item) 
{
	// type=password|class=|label=|fieldname=|max=|req=(TRUEFALSE)|confirm=(TRUEFALSE)

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && $item['req'] == 'true') ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '">' . $req_text . $item['label'] . '</label>' . "\n";
	$gen .= '<input class="' . $item['class'] . '" type="password" name="' . $item['fieldname'] . '" id="' . $item['fieldname'] . '" value="';
	$gen .= '"></p>' . "\n\n";

	if ($item['confirm'] == 'true') 
	{
		// Duplicate field (add 'c' to end)
		$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . 'c">' . $req_text . DDFM_CONFIRMPASS . ' ' . $item['label'] . '</label>' . "\n";
		$gen .= '<input class="' . $item['class'] . '" type="password" name="' . $item['fieldname'] . 'c" id="' . $item['fieldname'] . 'c" value="';
		$gen .= '"></p>' . "\n\n";
	}

	return $gen;
}


function ddfm_gen_textarea($item) 
{
	// type=textarea|class=|label=|fieldname=|max=|rows=|req=(TRUEFALSE)|[default=]

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && $item['req'] == 'true') ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '">' . $req_text . $item['label'] . '</label>' . "\n";
	$gen .= '<textarea class="' . $item['class'] . '" name="' . $item['fieldname'] . '" cols="20" rows="' . $item['rows'] . '" id="' . $item['fieldname'] . '">';

	if ($form_submitted) 
	{
		$gen .= ddfm_bsafe($form_input[$item['fieldname']]);
	} 
	elseif (isset($item['default'])) 
	{
		$gen .= ddfm_bsafe($item['default']);
	}
	$gen .= '</textarea></p>' . "\n";
	return $gen;
}


function ddfm_gen_widetextarea($item) 
{
	// type=widetextarea|class=|label=|fieldname=|max=|rows=|req=(TRUEFALSE)|[default=]

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && $item['req'] == 'true') ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '" class="ddmf_textlblwide">' . $req_text . $item['label'] . '</label>' . "\n";
	$gen .= '<textarea class="' . $item['class'] . '" name="' . $item['fieldname'] . '" cols="20" rows="' . $item['rows'] . '" id="' . $item['fieldname'] . '">';

	if ($form_submitted) 
	{
		$gen .= ddfm_bsafe($form_input[$item['fieldname']]);
	} 
	elseif (isset($item['default'])) 
	{
		$gen .= ddfm_bsafe($item['default']);
	}
	$gen .= '</textarea></p>' . "\n";
	return $gen;
}


function ddfm_gen_verify($item) 
{
	// type=verify|class=|label=

	global $verify_method, $show_required, $script_path, $pth, $errors, $plugin_cf;

	if ($verify_method != 'basic') return '';

	$req_text = ($show_required) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<div id="ddfmFormmail" class="ddfmFormmail"></div>';

	if (ddfm_check_gd_support()) 
	{
		$gen .= '<div style="border: 0; clear: both;" class="fieldwrap"><label for="fm_verify">' . $req_text . $item['label'] . '</label>' . "\n";
		
		if($plugin_cf['mailforms']['use_graphic_captcha'] == 'true')
		{
			$gen .= '<script>
document.write(\'<iframe src="' . $pth['folder']['base'] . 'plugins/mailforms/dd-captchaIframe.php" style="width: 100%; min-width: 256px; height: 70px; border: 0; padding: 0; margin: 0;"> </iframe>\');
</script>';
		}
		else
		{
			$gen .= '<script>
document.write(\'<iframe src="' . $pth['folder']['base'] . 'plugins/mailforms/dd-captchaOldIframe.php" style="width: 100%; height: 30px; border: 0px solid; padding: 0; margin: 0;"> </iframe>\');
</script>';
		}
		
		if($plugin_cf['mailforms']['use_graphic_captcha'] == 'true')
		{
			$gen .= '
<noscript>
<img src="' . $pth['folder']['base'] . 'plugins/mailforms/dd-captcha.php" class="ddfm_captcha" alt="' . $item['label'] . '" title="' . $item['label'] . '">
<input type="submit" name="form_submitted" value="&nbsp;" class="ddfmReload">
</noscript>';
		}
		else
		{
			$gen .= '
<noscript>
<img src="' . $pth['folder']['base'] . 'plugins/mailforms/dd-captcha.php" class="ddfm_captcha" alt="' . $item['label'] . '" title="' . $item['label'] . '">
</noscript>';
		}

		$gen .= '
<input class="'. $item['class'] . '" type="text" name="fm_verify" id="fm_verify" style="clear: both; width: 6em; margin: 0 0 9px 0;"></div>' . "\n";

	}
	return $gen;
}


function ddfm_gen_fullblock($item) 
{
	// type=fullblock|class=|text=

	$gen = "";

	$gen .= '<div class="' . $item['class'] . '"><p class="fieldwrap">' . "\n";
	$gen .= $item['text'] . "\n";
	$gen .= '</p></div>' . "\n\n";

	return $gen;
}


function ddfm_gen_halfblock($item) 
{
	// type=halfblock|class=|text=

	$gen = "";

	$gen .= '<div class="' . $item['class'] . '"><p class="fieldwrap">' . "\n";
	$gen .= $item['text'] . "\n";
	$gen .= '</p></div>' . "\n\n";

	return $gen;
}

  
function ddfm_gen_openfieldset($item) 
{
	// type=openfieldset|legend=

	$gen = "";
	$gen .= '<fieldset><legend>' . ddfm_bsafe($item['legend']) . '</legend>' . "\n\n";
	return $gen;
}


function ddfm_gen_closefieldset($item) 
{
	// type=closefieldset

	$gen = "";
	$gen .= '</fieldset>' . "\n\n";
	return $gen;
}


function ddfm_gen_checkbox($item) {

	// type=checkbox|class=|label=|data=
	//	 (fieldname),(text),(CHECKED),(REQUIRED),
	//	 (fieldname),(text),(CHECKED),(REQUIRED),
	//	 (fieldname),(text),(CHECKED),(REQUIRED)

	global $form_submitted, $form_input, $show_required;
	
	// ### added following line, add by MG ###
	$req_text = (($show_required) && $item['req'] == 'true') ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";

	// ### added $req_text to the following line, add by MG ###
	$gen .= '<p class="fieldwrap"><label>' . $req_text . $item['label'] . '</label><span class="' . $item['class'] . '">' . "\n";
	
	$item['data'] = str_replace(",,", "C0mM@", $item['data']);
	$data = explode(",", trim($item['data']));
	$data = str_replace("C0mM@", ",", $data);

	for ($i = 0; $i < sizeof($data); $i+=4) 
	{
		$req_text = (($show_required) && ($data[$i+3] == 'true')) ? ' <span class="required">' . DDFM_REQUIREDTAG . '</span>' : '';

		$gen .= '<input type="checkbox" name="' . $data[$i] . '" id="' . $data[$i] . '" value="' . $data[$i + 1] . '"';

		if ($form_submitted) 
		{
			if ((isset($form_input[$data[$i]])) && (trim($form_input[$data[$i]]) != '')) 
			{
				$gen .= ' checked="checked"';
			}
		} 
		else 
		{
			if ($data[$i + 2] == 'true') 
			{
				$gen .= ' checked="checked"';
			}
		}

		$gen .= '><label for="' . $data[$i] . '" class="ddmf_checklabel">' . $data[$i + 1] . $req_text . '</label><br>' . "\n";
	}

	$gen .= '</span></p>' . "\n\n";

	return $gen;
}


function ddfm_gen_radio($item) 
{
	//  type=radio|class=|label=|fieldname=|req=|[default=]|data=
	//	  (text),(text),(text)

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && ($item['req'] == 'true')) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label>' . $req_text . $item['label'] . '</label><span class="' . $item['class'] . '">' . "\n";
	
	$c = 1;

	$item['data'] = str_replace(",,", "C0mM@", $item['data']);
	$data = explode(",", trim($item['data']));
	$data = str_replace("C0mM@", ",", $data);
	
	for ($i = 0; $i < sizeof($data); $i++) 
	{
		$gen .= '<input type="radio" name="' . $item['fieldname'] . '" id="' . $item['fieldname'] . '_' . $i . '" value="' . $data[$i] . '"';

		if ($form_submitted) 
		{
			if (trim($form_input[$item['fieldname']]) == $data[$i]) 
			{
				$gen .= ' checked="checked"';
			}
		} 
		else 
		{
			if ($c == $item['default']) 
			{
				$gen .= ' checked="checked"';
			}
		}

		$gen .= '><label for="' . $item['fieldname'] . '_' . $i . '" class="ddmf_radiolabel">' . $data[$i] . '</label><br>' . "\n";

		$c++;
	}

	$gen .= '</span></p>' . "\n\n";

	return $gen;
}


function ddfm_gen_select($item) 
{
	//	type=select|class=|label=|fieldname=|multi=(TRUEFALSE)|data=
	//    (#group),(text),(text),(#group),(text),(text)

	global $form_submitted, $form_input, $show_required;

	$req_text = (($show_required) && ($item['req'] == 'true')) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label>' . $req_text . $item['label'] . '</label><select class="' . $item['class'] . '" id="' . $item['fieldname'] . '" name="' . $item['fieldname'];

	if ($item['multi'] == 'true') 
	{
		$gen .= '[]';
	}

	$gen .= '"';

	if ($item['multi'] == 'true') 
	{
		$gen .= ' multiple="multiple"';
	}

	$gen .= '>' . "\n";
	
	$c = 1;

	$og = FALSE;

	$item['data'] = str_replace(",,", "C0mM@", $item['data']);
	$data = explode(",", trim($item['data']));
	$data = str_replace("C0mM@", ",", $data);

	for ($i = 0; $i < sizeof($data); $i++) 
	{
		if (substr($data[$i], 0, 1) == '#' ) 
		{
			if ($og) 
			{
				$gen .= '</optgroup>' . "\n";	
			}
			$gen .= '<optgroup label="' . ltrim($data[$i], '#') . '">' . "\n";
			$og = TRUE;

		} 
		else 
		{
			$gen .= '<option';

			if ($form_submitted) 
			{
				if ($item['multi'] == 'true') 
				{
					foreach ((array)$form_input[$item['fieldname']] as $ii) 
					{
						if ($data[$i] == $ii) 
						{
							$gen .= ' selected="selected"';
						}
					}
				} 
				else 
				{
					if (trim($form_input[$item['fieldname']]) == $data[$i]) 
					{
						$gen .= ' selected="selected"';
					}
				}
			} 
			$gen .= ' >' . $data[$i] . '</option>' . "\n";
		}
		$c++;
	}

	if ($og) 
	{
		$gen .= '</optgroup>' . "\n";
		$og = FALSE;
	} 
	$gen .= '</select></p>' . "\n\n";
	return $gen;
}


function ddfm_gen_file($item) 
{
	// type=file|class=|label=|fieldname=|req=(TRUEFALSE)|[allowed=1,2,3]

	global $form_submitted, $form_input, $show_required, $max_file_size;

	$req_text = (($show_required) && ($item['req'] == 'true')) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";

	$gen .= '<p class="fieldwrap"><label for="' . $item['fieldname'] . '">' . $req_text . $item['label'] . '</label>' . "\n";
	$gen .= '<input class="' . $item['class'] . '" type="file" name="' . $item['fieldname'] . '" id="' . $item['fieldname'] . '" ';
	$gen .= '></p>' . "\n\n";

	return $gen;
}


function ddfm_gen_selrecip($item) 
{
	// type=selrecip|class=|label=|data=User1,user1@domain.com,User2 etc..

	global $form_submitted, $form_input, $show_required;

	$req_text = ($show_required) ? '<span class="required">' . DDFM_REQUIREDTAG . '</span> ' : '';

	$gen = "";
	$gen .= '<p class="fieldwrap"><label>' . $req_text . $item['label'] . '</label><select class="' . $item['class'] . '" name="fm_selrecip">' . "\n";
	
	$data = explode(",", trim($item['data']));

	$gen .= '<option';
	if ($form_submitted) 
	{
		if (trim($form_input['fm_selrecip']) == $data[0]) 
		{
			$gen .= ' selected="selected"';
		}
	}
	$gen .= ' >' . $data[0] . '</option>' . "\n";

	for ($i = 1; $i < sizeof($data); $i+=2) 
	{
		$gen .= '<option';

		if ($form_submitted) 
		{
			if (trim($form_input['fm_selrecip']) == $data[$i]) 
			{
				$gen .= ' selected="selected"';
			}
		}
		$gen .= ' >' . $data[$i] . '</option>' . "\n";
	}
	$gen .= '</select></p>' . "\n\n";
	return $gen;
}


// END of functions to show form output



/* Generate the script output */

// convert $form_struct into array of strings
$form_struct = (array)explode('<br>', nl2br(trim($form_struct), false));

// Prepare globals
$form_submitted = FALSE;
$message_sent = FALSE;

// Prepare output
$ddfmOutput = "\n\n\n" . '<!-- START of Dagon Design Formmailer output -->' . "\n\n";

// Convert form structure to multi-dimensional array
$fs_tmp1 = array();
$fs_tmp2 = array();
$fitem = 0;

foreach ($form_struct as $fs) 
{
	if (trim($fs) != "") 
	{
		$fs_tmp1 = (array)explode("|", trim($fs));
		foreach ($fs_tmp1 as $fs1) 
		{
			if($fs1 != '' && strstr($fs1,'='))
			{
				list($k, $v) = (array)explode("=", trim($fs1), 2);
				$fs_tmp2[$fitem][$k] = $v;
			}
		}
	}
	$fitem++;
}
$form_struct = $fs_tmp2;

// Make sure form structure is not missing empty keys
$valid_keys = array('fieldname', 'type', 'req', 'label', 'max', 'ver', 'confirm', 'data', 'multi', 'allowed', 'default');

for ($i = 0; $i < count($form_struct); $i++) 
{
	foreach ($valid_keys as $k) 
	{
		if (!isset($form_struct[$i][$k])) $form_struct[$i][$k] = NULL;
	}
}

// Do a quick check to make sure there are no duplicate field names 
$dd_unique_fields = array();
$dd_unique_test = TRUE;
foreach ($form_struct as $fs) 
{
	if ($dd_unique_test && ($fs['fieldname'] != NULL) && (in_array($fs['fieldname'], $dd_unique_fields))) 
	{
		$dd_unique_test = FALSE;
	} 
	else 
	{
		$dd_unique_fields[] = $fs['fieldname'];
	}
}

// changed for CMSimple
if (!$dd_unique_test) 
{
	$ddfmOutput.= '<p class="cmsimplecore_warning">*** ERROR - You have duplicate fieldnames in your form structure ***</p>';
	return;
}

// Was form submitted?

if (isset($_POST["form_submitted"])) 
{
	$form_submitted = TRUE;

	$mail_message = "";
	$csv = "";
	
	$orig_auto_reply_message = $auto_reply_message;
	$auto_reply_message = '';
	
	// make correct encoding in auto - sokai - BEGIN
	$mime_boundary = md5(time());
	$auto_reply_message .= '--' . $mime_boundary . MF_LE;
	$auto_reply_message .= 'Content-Type: text/plain; charset="utf-8"' . MF_LE;
	$auto_reply_message .= 'Content-Transfer-Encoding: 8bit' . MF_LE . MF_LE;
	// make correct encoding in auto - sokai - END

	$attached_files = array();
	$attached_index = 0;

	$sel_recip = NULL;

	$message_structure = trim($message_structure);

	$auto_reply_message .= $orig_auto_reply_message;

	unset($errors);
	$errors = array();

	if ($verify_method == 'recaptcha') 
	{
		include_once('recaptchalib.php');
		$privatekey = $re_private_key;
		$resp = recaptcha_check_answer ($privatekey,
							$_SERVER["REMOTE_ADDR"],
							$_POST["recaptcha_challenge_field"],
							$_POST["recaptcha_response_field"]);
		if (!$resp->is_valid) 
		{
			$errors[] = DDFM_INVALIDVER;
		}
	}

	// Get form input and put in array
	foreach ($_POST as $key => $i) 
	{
		if ($key != "form_submitted") 
		{
			if (!is_array($i)) 
			{
				$form_input[strtolower($key)] = trim($i);
			} 
			else 
			{
				$form_input[strtolower($key)] = $i;
			}
		}
	}
	
	$msg_field_sep = ': ';
	$msg_field_line_end = "\n\n";

	$fsindex = -1;

	// Validate input
	foreach ($form_struct as $fs) 
	{
		if (!isset($form_input[$fs['fieldname']])) 
		{
			$form_input[$fs['fieldname']] = '';
		}

		$fsindex++;

		// check for fields used in vars
		if (isset($form_input[$fs['fieldname']])) 
		{
			$sender_name = ddfm_str_replace($fs['fieldname'], ddfm_stripslashes($form_input[$fs['fieldname']]), $sender_name);
			$sender_email = ddfm_str_replace($fs['fieldname'], ddfm_stripslashes($form_input[$fs['fieldname']]), $sender_email);
			$email_subject = ddfm_str_replace($fs['fieldname'], ddfm_stripslashes($form_input[$fs['fieldname']]), $email_subject);
		}

		switch ($fs['type']) 
		{
			case 'date':

				// type=date|class=|label=|fieldname=|req=(TRUEFALSE)

				$t = ddfm_stripslashes($form_input[$fs['fieldname']]);

				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && ($t == "")) 
				{ 
					$errors[] = $fs['label'];
				} 
				elseif (ddfm_injection_chars($t)) 
				{
					$errors[] = DDFM_INVALIDINPUT . " '" . $fs['label'] . "'";
				} 

				$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;
				$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
				$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
				$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
				$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);

				break;

			case 'text':

				// type=text|class=|label=|fieldname=|max=|req=(TRUEFALSE)|[ver=]|[default=]

				$t = ddfm_stripslashes($form_input[$fs['fieldname']]);

				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && ($t == "")) 
				{ 
					$errors[] = $fs['label'];
				} 
				elseif (strlen($t) > (int)$fs['max']) 
				{
					$errors[] = $fs['max'] . ' ' . DDFM_MAXCHARLIMIT . " '" . $fs['label'] . "'";
				} 
				elseif (ddfm_injection_chars($t)) 
				{
					$errors[] = DDFM_INVALIDINPUT . " '" . $fs['label'] . "'";
				} 
				elseif (isset($fs['ver']) && (strtolower($fs['ver']) == 'email') && ((strtolower($fs['req']) == "true") || ($t != ""))) 
				{
					if (!dd_is_valid_email($t)) $errors[] = DDFM_INVALIDEMAIL . " '" . $fs['label'] . "'";
				} 
				elseif (isset($fs['ver']) && (strtolower($fs['ver']) == 'url') && (isset($fs['req']) && (strtolower($fs['req']) == "true") || ($t != ""))) 
				{
					if (!ddfm_is_valid_url($t)) $errors[] = DDFM_INVALIDURL . " '" . $fs['label'] . "'";
				} 

				if($fs['fieldname'] != 'ddmf_sender_phone_hpt')
				{
					$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;
					$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
					$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
					$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
					$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);
				}

				break;

			case 'password':

				// type=password|class=|label=|fieldname=|max=|req=(TRUEFALSE)|confirm=(TRUEFALSE)
				$t = ddfm_stripslashes($form_input[$fs['fieldname']]);

				if ((strtolower($fs['req']) == 'true') && ($t == "")) 
				{
					$errors[] = $fs['label'];
				} 
				elseif (strlen($t) > (int)$fs['max']) {

					$errors[] = $fs['max'] . ' ' . DDFM_MAXCHARLIMIT . " '" . $fs['label'] . "'";

				} 
				elseif (ddfm_injection_chars($t)) 
				{
					$errors[] = DDFM_INVALIDINPUT . " '" . $fs['label'] . "'";
				} 
				elseif (strtolower($fs['confirm']) == 'true') 
				{
					$tc = ddfm_stripslashes($form_input[$fs['fieldname']  . 'c']);
					if ($t != $tc) $errors[] = DDFM_NOMATCH . " '" . $fs['label'] . "'";
				}

				$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;
				$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
				$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
				$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
				$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);

				break;

			case 'textarea':
			case 'widetextarea':
		
				// type=textarea|class=|label=|fieldname=|max=|rows=|req=(TRUEFALSE)|[default=]

				$t = ddfm_stripslashes($form_input[$fs['fieldname']]);

				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && ($t == "")) 
				{
					$errors[] = $fs['label'];
				} 
				elseif (strlen($t) > (int)$fs['max']) 
				{
					$errors[] = $fs['max'] . ' ' . DDFM_MAXCHARLIMIT . " '" . $fs['label'] . "'";
				}

				$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;
				$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
				$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
				$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
				$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);

				break;

			case 'verify':

				// type=verify|class=|label=

				if ($verify_method == 'basic') 
				{
					$t = ddfm_stripslashes($form_input['fm_verify']);
					if ($t == "") 
					{
						$errors[] = DDFM_MISSINGVER;
					} 
					elseif (trim($_COOKIE["ddfmcode"]) == "") 
					{
						$errors[] = DDFM_NOVERGEN;
					} 
					elseif ($_COOKIE["ddfmcode"] != md5(strtoupper($t))) 
					{ 
						$errors[] = DDFM_INVALIDVER;
					} 
				}

				break;

			case 'checkbox':

				//  type=checkbox|class=|label=|data=
				//	  (fieldname),(text),(CHECKED),(REQUIRED),
				//	  (fieldname),(text),(CHECKED),(REQUIRED),
				//	  (fieldname),(text),(CHECKED),(REQUIRED)

				// ### following three lines edited in order to have commas in the values, add by MG ###
				$fs['data'] = str_replace(",,", "C0mM@", $fs['data']);
				$data = explode(",", trim($fs['data']));
				$data = str_replace("C0mM@", ",", $data);

				$tmp_msg = array();
				
				$checkBoxChecked = false; //### added by MG ###

				for ($i = 0; $i < count($data); $i+=4) 
				{
					$t = '';
					if (isset($form_input[$data[$i]])) 
					{
						$t = ddfm_stripslashes(trim($form_input[$data[$i]]));
					}

					if ((strtolower($data[$i+3]) == 'true') && ($t == "")) 
					{
						$errors[] = $fs['label'];
					}

					if ($t != "") 
					{
						$tmp_msg[] = $t;
						$checkBoxChecked = true; //### added by MG ###
					}

					$message_structure = ddfm_str_replace($data[$i], $t, $message_structure);
					$auto_reply_message = ddfm_str_replace($data[$i], $t, $auto_reply_message);
					$sent_message = ddfm_str_replace($data[$i], ddfm_bsafe($t), $sent_message);
				}
				
				// ### start of changes by MG ###
				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && !$checkBoxChecked) 
				{ 
					$errors[] = $fs['label'];
				}
				// ### end of changes by MG ###

				$csv .= str_replace($save_delimiter, ' ', implode(', ', $tmp_msg)) . $save_delimiter;
				$mail_message .= $fs['label'] . $msg_field_sep . implode(', ', $tmp_msg) . $msg_field_line_end;

				break;
			
			case 'radio':

				//  type=radio|class=|label=|fieldname=|req=|[default=]|data=
				//	  (text),(text),(text),(text)

				$t = ddfm_stripslashes(trim($form_input[$fs['fieldname']]));

				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && ($t == "")) 
				{
					$errors[] = $fs['label'];
				}

				$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;	
				$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
				$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
				$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
				$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);

				break;

			case 'select':

				//  type=select|class=|label=|fieldname=|multi=(TRUEFALSE)|data=
				//    (#group),(text),(text),(#group),(text),(text)

				$data = explode(",", trim($fs['data']));

				if (isset($fs['multi']) && strtolower($fs['multi']) != 'true') 
				{
					$t = ddfm_stripslashes($form_input[$fs['fieldname']]);
					$first_item = $data[0];

					if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && (($t == "") || ($t == $first_item))) 
					{
						$errors[] = $fs['label'];
					}
				
					$csv .= str_replace($save_delimiter, ' ', $t) . $save_delimiter;
					$mail_message .= $fs['label'] . $msg_field_sep . $t . $msg_field_line_end;
					$message_structure = ddfm_str_replace($fs['fieldname'], $t, $message_structure);
					$auto_reply_message = ddfm_str_replace($fs['fieldname'], $t, $auto_reply_message);
					$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe($t), $sent_message);
				} 
				else  // multi = true
				{
					$t = (array)$form_input[$fs['fieldname']];

					if ((count($t) == 1) && ($t[0] == '')) 
					{
						unset($t[0]);
					}

					if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && (count($t) == 0)) 
					{
						$errors[] = $fs['label'];
					}
					
					$tmp_msg = array();

					foreach ($t as $tt) 
					{
						if ($tt != "") $tmp_msg[] = $tt;
					}

					$csv .= str_replace($save_delimiter, ' ', implode(', ', $tmp_msg)) . $save_delimiter;
					$mail_message .= $fs['label'] . $msg_field_sep . implode(', ', $tmp_msg) . $msg_field_line_end;
					$message_structure = ddfm_str_replace($fs['fieldname'], implode(', ', $tmp_msg), $message_structure);
					$auto_reply_message = ddfm_str_replace($fs['fieldname'], implode(', ', $tmp_msg), $auto_reply_message);
					$sent_message = ddfm_str_replace($fs['fieldname'], ddfm_bsafe(implode(', ', $tmp_msg)), $sent_message);
				}
				break;

			case 'file':

				// type=file|class=|label=|fieldname=|[req=]|[allowed=1,2,3]

				if (isset($fs['req']) && (strtolower($fs['req']) == 'true') && (($_FILES[$fs['fieldname']]['name'] == ""))) 
				{ 
					$errors[] = DDFM_MISSINGFILE . " '" . $fs['label'] . "'";
				}

				$allowed = array();

				if (isset($fs['allowed']) && trim($fs['allowed']) != "") 
				{
					$allowed = (array)explode(",", trim(strtolower($fs['allowed'])));
				}

				if (($_FILES[$fs['fieldname']]['name'] != "") && ((int)$_FILES[$fs['fieldname']]['size'] == 0)) 
				{
						$errors[] = DDFM_FILETOOBIG . ' ' . $_FILES[$fs['fieldname']]['name'];
				} 
				elseif ($_FILES[$fs['fieldname']]['tmp_name'] != "") 
				{
					if (($_FILES[$fs['fieldname']]['error'] == UPLOAD_ERR_OK) && ($_FILES[$fs['fieldname']]['size'] > 0)) 
					{
						$origfilename = $_FILES[$fs['fieldname']]['name'];
						$filename = explode(".", $_FILES[$fs['fieldname']]['name']);
						$filenameext = $filename[count($filename) - 1];
						unset($filename[count($filename) - 1]);
						$filename = implode(".", $filename);
						$filename = substr($filename, 0, 15) . "." . $filenameext;
						$file_ext_allow = TRUE;

						if (count($allowed) > 0) 
						{
							$file_ext_allow = FALSE;
							
							for ($x = 0; $x < count($allowed); $x++) 
							{ 
								if (strtolower($filenameext) == strtolower($allowed[$x])) 
								{
									$file_ext_allow = TRUE;
								}
							} 
						}
						if ($file_ext_allow) 
						{
							if((int)$_FILES[$fs['fieldname']]['size'] < $max_file_size) 
							{
								$attached_files[$attached_index]['file'] = $_FILES[$fs['fieldname']]['name']; 
								$attached_files[$attached_index]['tmpfile'] = $_FILES[$fs['fieldname']]['tmp_name']; 
								$attached_files[$attached_index]['content_type'] = $_FILES[$fs['fieldname']]['type']; 
								$attached_index++;

								$csv .= str_replace($save_delimiter, ' ', $_FILES[$fs['fieldname']]['name']) . $save_delimiter;
								
								if (!$attach_save) 
								{
									$mail_message .= DDFM_ATTACHED . $msg_field_sep . $_FILES[$fs['fieldname']]['name'] . $msg_field_line_end; 
								} 
								else 
								{
									$mail_message .= $fs['label'] . $msg_field_sep . $_FILES[$fs['fieldname']]['name'] . $msg_field_line_end;
								}
								
								$message_structure = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $message_structure);
								$auto_reply_message = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $auto_reply_message);
								$sent_message = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $sent_message);					

							} 
							else 
							{ 
								$errors[] = DDFM_FILETOOBIG . ' ' . $_FILES[$fs['fieldname']]['name'];
							}
						} 
						else 
						{ 
							$errors[] = DDFM_INVALIDEXT . ' ' . $_FILES[$fs['fieldname']]['name'];
						}
					} 
					else 
					{ 
						$errors[] = DDFM_UPLOADERR . ' ' . $_FILES[$fs['fieldname']]['name'];
					}
				} 

				/* handled above 
				$csv .= str_replace($save_delimiter, ' ', $_FILES[$fs['fieldname']]['name']) . $save_delimiter;
				$mail_message .= $fs['label'] . $msg_field_sep . $_FILES[$fs['fieldname']]['name'] . $msg_field_line_end;
				$message_structure = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $message_structure);
				$auto_reply_message = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $auto_reply_message);
				$sent_message = ddfm_str_replace($fs['fieldname'], $_FILES[$fs['fieldname']]['name'], $sent_message);
				*/
				
				break;


			case 'selrecip':

				//  type=selrecip|class=|label=|data=(select),User1,user1@domain.com,User2 etc..

				$data = explode(",", trim($fs['data']));
				$t = ddfm_stripslashes($form_input['fm_selrecip']);

				if (($t == "") || ($t == $data[0])) 
				{
					$errors[] = $fs['label'];
				} 
				else 
				{
					for ($i = 1; $i < count($data); $i+=2) 
					{
						if ($data[$i] == $t) 
						{
							$sel_recip = trim($data[$i+1]);
						}
					}
				}	
				break;
		}
	}

	// make sure no un-used fieldnames are left in template
	foreach ($form_struct as $fs) 
	{
		$message_structure = ddfm_str_replace($fs['fieldname'], '', $message_structure);
		$auto_reply_message = ddfm_str_replace($fs['fieldname'], '', $auto_reply_message);
		$sent_message = ddfm_str_replace($fs['fieldname'], '', $sent_message);
	}

	if (ddfm_injection_chars($sender_name)) $errors[] = DDFM_INVALIDINPUT;
	if (ddfm_injection_chars($sender_email)) $errors[] = DDFM_INVALIDINPUT;
	if (ddfm_injection_chars($email_subject)) $errors[] = DDFM_INVALIDINPUT;
	
	if ($errors) 
	{
		$ddfmOutput.= '<br>';
	} 
	else 
	{

		if ($wrap_messages) 
		{
			$mail_message = wordwrap($mail_message, 70);
		}

		if ($recipients == 'selrecip') 
		{
			$recipients = $sel_recip;
		}

		// if template exists, use it instead
		if (strlen(trim($message_structure)) > 0) 
		{
			$mail_message = $message_structure . "\n\n";
		}

		if ($show_ip_hostname) 
		{
			$mail_message .= 'IP: ' . $_SERVER['REMOTE_ADDR'] . "\n" . 'HOST: ' . gethostbyaddr($_SERVER['REMOTE_ADDR']) . "\n";
		}

		$sndmsg = TRUE;
		if (($save_to_file == TRUE) && ($save_email == FALSE)) 
		{
			$sndmsg = FALSE;
		}
		
		$csv = str_replace("\n", $save_newlines, $csv);
		$csv = str_replace("\r", '', $csv);
		$csv = substr($csv, 0, strlen($csv) - strlen($save_delimiter));

		if (trim($save_timestamp) != '') 
		{
			$csv = date($save_timestamp) . $save_delimiter . $csv;
		}

		if (is_writable($save_path)) 
		{
			$handle = fopen($save_path, 'a+');
			fwrite($handle, $csv . "\n");
			fclose($handle);
		}

		if ($show_url == TRUE) 
		{
			$mail_message .= "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		}

		if ($sndmsg == TRUE) 
		{
			if (ddfm_send_mail($recipients, $sender_name, $sender_email, $email_subject, $mail_message, $attach_save, $attach_path, $attached_files)) 
			{
//				$ddfmOutput.= $sent_message;

				$auto_reply_name = trim($auto_reply_name);
				$auto_reply_email = trim($auto_reply_email);
				$auto_reply_subject = trim($auto_reply_subject);
				$auto_reply_message = trim($auto_reply_message);

				if (($orig_auto_reply_message != "") && (trim($sender_email != ""))) 
				{
					$auto_reply_headers = '';

					$auto_reply_headers .= 'From: ' . $auto_reply_name . ' <' . $auto_reply_email . '>' . MF_LE;
					$auto_reply_headers .= 'Reply-To: ' . $auto_reply_name . ' <' . $auto_reply_email . '>' . MF_LE;
					$auto_reply_headers .= 'Return-Path: ' . $auto_reply_name . ' <' . $auto_reply_email . '>' . MF_LE;;
					$auto_reply_headers .= "Message-ID: <" . time() . "ddfm@" . $_SERVER['SERVER_NAME'] . ">" . MF_LE;
					$auto_reply_headers .= 'X-Sender-IP: ' . $_SERVER["REMOTE_ADDR"] . MF_LE;
					$auto_reply_headers .= "X-Mailer: PHP v" . phpversion() . MF_LE;

					$auto_reply_headers .= 'MIME-Version: 1.0' . MF_LE;
					$auto_reply_headers .= 'Content-Type: multipart/related; boundary="' . $mime_boundary . '"';
					/*$auto_reply_headers .= 'Content-Type: text/plain; charset=utf-8';*/
					// make correct encoding in auto - sokai - BEGIN
					//$auto_reply_message .= MF_LE . MF_LE;
					$auto_reply_message .= MF_LE . MF_LE . '--' . $mime_boundary . '--' . MF_LE . MF_LE;
					// make correct encoding in auto - sokai - END

					mail($sender_email, $auto_reply_subject, $auto_reply_message, $auto_reply_headers);
				}
				$message_sent = TRUE;
				$_POST = array();
			}
			else 
			{
				$ddfmOutput.= '<div class="ddmfServerError"><b>Server Error</b>' . DDFM_SERVERERR . '</div>';
				$message_sent = FALSE;
			}
		}
		else 
		{
			$ddfmOutput.= $sent_message;
		}
	}
} // end of form submission processing


// Generate form if message has not been sent

if(isset($_REQUEST['ddfmFormSent']))
{
	$ddfmOutput.= $sent_message;
	$ddfmOutput.= '<p class="ddfm_backToForm"><a href="' . str_replace('#ddfmFormmail','',$path_contact_page) . '">' . $plugin_tx['mailforms']['frontend_back_to_form'] . '</a></p>';
}

if (!$message_sent && !isset($_REQUEST['ddfmFormSent'])) 
{
	if ($verify_method == 'basic' && !ddfm_check_gd_support()) 
	{
		$ddfmOutput.= DDFM_GDERROR;
	}

	if(!isset($ddmfLayout) || $ddmfLayout == '')
	{
		$ddmfLayout = '1col';
	}

	if(isset($errors)) 
	{
		$ddfmOutput.= '
<div class="ddfmwrap">
<div class="errorlist">
';
		$ddfmOutput.= $plugin_tx['mailforms']['ddfm_server_error'] . '
<hr>
<p>' . DDFM_MISSINGFIELD . '</p>
<ul>
';
		foreach ($errors as $err) 
		{
			$ddfmOutput.= '<li>' . $err . '</li>' . "\n";
		}
		$ddfmOutput.= '</ul>
</div>
<div style="clear:both;"></div>
</div>
';
	}

	$ddfmOutput.= '<div class="ddfmwrap">
<form class="ddmf' . $ddmfLayout . '" method="post" action="' . $path_contact_page . '" enctype="multipart/form-data">' . "\n\n";

	// Loop through form items

	foreach ($form_struct as $f_i) 
	{
		switch ($f_i['type']) 
		{
			case 'html':			$ddfmOutput.= ddfm_gen_html($f_i);				break;
			case 'date':			$ddfmOutput.= ddfm_gen_date($f_i);				break;
			case 'text':			$ddfmOutput.= ddfm_gen_text($f_i);				break;
			case 'password':		$ddfmOutput.= ddfm_gen_password($f_i);			break;
			case 'textarea':		$ddfmOutput.= ddfm_gen_textarea($f_i);			break;
			case 'widetextarea':	$ddfmOutput.= ddfm_gen_widetextarea($f_i);		break;
			case 'verify':			$ddfmOutput.= ddfm_gen_verify($f_i);			break;
			case 'fullblock':		$ddfmOutput.= ddfm_gen_fullblock($f_i);			break;
			case 'halfblock':		$ddfmOutput.= ddfm_gen_halfblock($f_i);			break;
			case 'openfieldset':	$ddfmOutput.= ddfm_gen_openfieldset($f_i);		break;
			case 'closefieldset':	$ddfmOutput.= ddfm_gen_closefieldset($f_i);		break;
			case 'checkbox':		$ddfmOutput.= ddfm_gen_checkbox($f_i);			break;
			case 'radio':			$ddfmOutput.= ddfm_gen_radio($f_i);				break;
			case 'select':			$ddfmOutput.= ddfm_gen_select($f_i);			break;
			case 'file':			$ddfmOutput.= ddfm_gen_file($f_i);				break;
			case 'selrecip':		$ddfmOutput.= ddfm_gen_selrecip($f_i);			break;
		}
	}

	if ($verify_method == 'recaptcha') 
	{
		$ddfmOutput.= "<script>
		var RecaptchaOptions = {
		theme : 'white'
		};
		</script>";

		include_once('recaptchalib.php');
		$publickey = $re_public_key;

		$ddfmOutput.= '<div class="recaptcha"><div class="recaptcha-inner">';
		$ddfmOutput.= recaptcha_get_html($publickey);
		$ddfmOutput.= '</div></div>';
	}

	$ddfmOutput.= '<p><input type="hidden" name="MAX_FILE_SIZE" value="' . $max_file_size . '"></p>' . "\n";
	$ddfmOutput.= '<div style="clear: both;"></div>';
	
	$ddfmOutput.= '<div class="submitButton"><input type="submit" name="form_submitted" value="' . DDFM_SUBMITBUTTON . '"></div>' . "\n\n";
	
	if(isset($sndmsg) && $sndmsg == TRUE)
	{
		if (!ddfm_send_mail($recipients, $sender_name, $sender_email, $email_subject, $mail_message, $attach_save, $attach_path, $attached_files))
		{
			$ddfmOutput.= '<div class="ddmfServerError"><b>Server Error</b>' . DDFM_SERVERERR . '</div>';
		}
	}
	
	if(isset($errors)) 
	{
		$ddfmOutput.= '
<div class="ddfmwrap">
<div class="errorlist">
';
		$ddfmOutput.= $plugin_tx['mailforms']['ddfm_server_error'] . '
<hr>
<p>' . DDFM_MISSINGFIELD . '</p>
<ul>
';
		foreach ($errors as $err) 
		{
			$ddfmOutput.= '<li>' . $err . '</li>' . "\n";
		}
		$ddfmOutput.= '</ul>
</div>
<div style="clear:both;"></div>
</div>
';
	}

//			$ddfmOutput.= '<div class="credits">' . DDFM_CREDITS . ' <a href="http://www.dagondesign.com" title="Dagon Design">Dagon Design</a></div>' . "\n\n";

	$ddfmOutput.= '</form>
</div>
';

	// Form generation complete

} // end of display form code
else
{
	if(!isset($_REQUEST['ddfmFormSent']))header('Location: ' . $path_contact_page_sent);
}

$ddfmOutput.= '

<!-- END of Dagon Design Formmailer output -->' . "\n\n\n";

?>