<?php

if (!function_exists('sv') || preg_match('#plugins/newsblog/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin NewsBlog
============================================================
Version:    NewsBlog 2.3
Released:   2023-01
Copyright:  Gert Ebersbach - www.ge-webdesign.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
utf-8 check: äöü 
*/

if($s>-1 && stristr($c[$s],'newsblogBL(')) $cf['show']['page_headings'] = 'true';

// prepare first and last entry for page splitting

if(!isset($_GET['nbfirst']))
{
	$nbfirst = "1";
}
else
{
	if (!preg_match("#^[0-9]+$#", $_GET['nbfirst']))
	{
		$nbfirst = "1";
	}
	else
	{
		$nbfirst = $_GET['nbfirst'];
	}
}

$nblast = ($nbfirst + $plugin_cf['newsblog']['split_number_of_entries']) - 1;


if(isset($_GET['nbcat']))
{
	$newsblogCategory = stripslashes(strip_tags(htmlspecialchars(uenc($_GET['nbcat']), ENT_QUOTES, 'UTF-8')));
}
else
{
	$newsblogCategory = 'all';
}


function newsblogPageNav() // page splitting navigation
{
	global $su, $newsblogEntriesArray, $plugin_cf, $plugin_tx, $newsblogPages, $nbfirst, $nblast, $nbcat, $newsblogCategory;
	
	// create pages array
	if(!isset($newsblogPages))
	{
		$newsboxPage = 1;
		while ($newsboxPage < ((count($newsblogEntriesArray) / $plugin_cf['newsblog']['split_number_of_entries']) +1))
		{
		   $newsblogPages[] = $newsboxPage++;
		}
	}
	
	$newsblogPagesLeftRight = $plugin_cf['newsblog']['split_shown_pages_left_right'];
	
	if(count($newsblogPages) > '1')
	{
		$o = '<div class="newsblogPagenav">';
		
		// newest entries
		if(count($newsblogPages) >= $newsblogPagesLeftRight * 2 + 2 && $nbfirst >= $plugin_cf['newsblog']['split_shown_pages_left_right'] * $plugin_cf['newsblog']['split_number_of_entries'] + 2)
		{
			$o.= '<a href="?' . $su . '&amp;nbfirst=1&amp;nbcat=' . uenc($newsblogCategory) . '#newsblogTop" title="' . $plugin_tx['newsblog']['info_newest_entries'] . '"><span class="newsblogBoxArrow">&laquo;</span></a>';
		}
		else
		{
			$o.= '<span class="newsblogBoxArrow">&nbsp;&nbsp;</span>';
		}
		
		// page number boxes
		foreach($newsblogPages as $key => $newsblogPagesBox)
		{
			if(($key * $plugin_cf['newsblog']['split_number_of_entries'] +1) == $nbfirst)
			{
				$o.= '<span class="newsblogBoxActive">' . $newsblogPagesBox . '</span>';
			}
			else
			{
				if
				(
					($newsblogPagesBox >= ($nblast / $plugin_cf['newsblog']['split_number_of_entries'] - $newsblogPagesLeftRight) && $newsblogPagesBox <= ($nblast / $plugin_cf['newsblog']['split_number_of_entries'] + $newsblogPagesLeftRight)) ||
					($newsblogPagesBox <= ($newsblogPagesLeftRight * 2 + 1) && $newsblogPagesBox >= $nbfirst - $plugin_cf['newsblog']['split_number_of_entries']) ||
					($newsblogPagesBox >= (count($newsblogPages) - ($newsblogPagesLeftRight * 2)) && $newsblogPagesBox <= $nblast / $plugin_cf['newsblog']['split_number_of_entries'])
				)
				{
					$o.= '<a href="?' . $su . '&amp;nbfirst=' . (($key * $plugin_cf['newsblog']['split_number_of_entries']) + 1) . '&amp;nbcat=' . uenc($newsblogCategory) . '#newsblogTop"><span class="newsblogBoxInactive">' . $newsblogPagesBox . '</span></a>';
				}
			}
		}
		
		// oldest entries
		if(count($newsblogPages) >= $newsblogPagesLeftRight * 2 + 2  && $nbfirst <= (count($newsblogPages) * $plugin_cf['newsblog']['split_number_of_entries'] - $plugin_cf['newsblog']['split_number_of_entries'] * $plugin_cf['newsblog']['split_shown_pages_left_right'] - $plugin_cf['newsblog']['split_number_of_entries'] - 1))
		{
			$o.= '<a href="?' . $su . '&amp;nbfirst=' . (($key * $plugin_cf['newsblog']['split_number_of_entries']) + 1) . '&amp;nbcat=' . uenc($newsblogCategory) . '#newsblogTop" title="' . $plugin_tx['newsblog']['info_oldest_entries'] . '"><span class="newsblogBoxArrow">&raquo;</span></a>';
		}
		else
		{
			$o.= '<span class="newsblogBoxArrow">&nbsp;&nbsp;</span>';
		}
		$o.= '</div>';
		return $o;
	}
}


function newsblogCounter() // creates the counter
{
	global $plugin_cf, $plugin_tx, $nbfirst, $nblast, $newsblogEntriesArray;
	
	if($plugin_cf['newsblog']['split_number_of_entries'] > "1")
	{
		$o = "\n" . '<div class="newsblogCounter">' . $plugin_tx['newsblog']['info_entries_in_blog'] . ' ' . $nbfirst . ' - ' . ($nblast >= count($newsblogEntriesArray) ? count($newsblogEntriesArray) : $nblast) . ' (' . $plugin_tx['newsblog']['info_number_of_all_entries'] . '&nbsp;' . count($newsblogEntriesArray) . ')</div>' . "\n";
	}
	return $o;
}


function newsblog($newsblogCats='all') // main function
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	global $adm, $s, $sn, $su, $cl, $l, $h, $c, $cf, $plugin_cf, $plugin_tx, $newsblogEntriesArray, $nbfirst, $nblast, $page_data, $newsblogCategory;
	
	$newsblogEntriesArray = array();
	
	if($plugin_cf['newsblog']['set_anchor_above_blog'] == 'true')
	{
		$o = "\n" . '<div id="newsblogTop" class="newsblogAnchor"></div>';
	}
	else
	{
		$o = '';
	}
	
	// create categories array
	if($newsblogCats != 'all')
	{
		$newsblogCatsArray = explode('|',$newsblogCats);
		array_pop($newsblogCatsArray);
		$newsblogCatsArray = array_slice($newsblogCatsArray, 1);
	}
	
	// categories output
	if($newsblogCats != 'all'){$o.= "\n" . '<div class="newsblogCatsDiv">' . "\n";}
	
	if($newsblogCats == 'all')
	{
		$o.= '<span class="newsblogCatSpan newsblogCatAll"><a href="./?' . $su . '#newsblogTop">' . $plugin_tx['newsblog']['navi_all_categories'] . '</a></span><span class="newsblogCatSpacer"> </span>';
	}
	
	if($newsblogCats != 'all')
	{
		$o.= '<span class="newsblogCatSpan"><a href="./?' . $su . '#newsblogTop">' . $plugin_tx['newsblog']['navi_all_categories'] . '</a></span><span class="newsblogCatSpacer"> </span>';
		foreach($newsblogCatsArray as $newsblogCatsArrayElement)
		{
			if(!isset($newsblogCategory) || str_replace('_',' ',$newsblogCategory) != $newsblogCatsArrayElement)
			{
				$o.= '<span class="newsblogCatSpan"><a href="?' . $su . '&amp;nbcat=' . uenc($newsblogCatsArrayElement) . '#newsblogTop">' . $newsblogCatsArrayElement . '</a></span><span class="newsblogCatSpacer"> </span>';
			}
			else
			{
				$o.= '<span class="newsblogCatSpan">' . $newsblogCatsArrayElement . '</span><span class="newsblogCatSpacer"> </span>';
			}
		}
	}
	
	if($newsblogCats != 'all'){$o.= "\n" . '</div>' . "\n";}
	
	// create entries array
	$sNewsBlog = $s;
	if($sNewsBlog < 0) {$sNewsBlog = 0;}
	
	$tl = $l[$sNewsBlog] + 1 + $cf['menu']['levelcatch'];
	for ($i = $sNewsBlog + 1; $i < $cl; $i++) 
	{
		if ($l[$i] <= $l[$sNewsBlog]) 
		{
			break;
		}
		
		if ($l[$i] <= $tl && (!isset($newsblogCategory) || $newsblogCategory == 'all' || (strstr($c[$i],'|' . str_replace('_', ' ',$newsblogCategory) . '|'))))
		{
			if($plugin_cf['newsblog']['show_hidden_pages_only'] == 'true')
			{
				if(hide($i) && $c[$i] != '#CMSimple hide#') 
				{
					if(!stristr($c[$i],'NewsBlog21FirstPage'))$newsblogEntriesArray[] = $i;
				}
			}
			else
			{
				if($c[$i] != '' && $c[$i] != '#CMSimple hide#') 
				{
					if(!stristr($c[$i],'NewsBlog21FirstPage'))$newsblogEntriesArray[] = $i;
				}
			}
		}
		
		if ($l[$i] < $tl) 
		{
			$tl = $l[$i];
		}
	}
	
	
	// OUTPUT BLOG

	if($nbfirst < "1")
	{
		$nbfirst = "1";
		$nblast = $plugin_cf['newsblog']['split_number_of_entries'];
	}
	
	if (count($newsblogEntriesArray) > 0) 
	{
		$o.= "\n" . '<div class="newsblog_area">' . "\n";
		
		// output counter and page navigation
		$o.= newsblogCounter();
		$o.= newsblogPageNav();
		
		
		// prepare teasers
		if(isset($cf['use']['h1only_pagesplitting']) && $cf['use']['h1only_pagesplitting'] == 'true')
		{
			$newsblogEntry_headingclass = ' class="_level[1-6]_page_"';
		}
		else
		{
			$newsblogEntry_headingclass = '';
		}
		
		foreach ($newsblogEntriesArray as $key => $idExtension) 
		{
			$newsblogTeaser = str_replace('#CMSimple hide#', '', $c[$idExtension]);
			
			if(strstr($c[$idExtension],'<hr') || $adm)
			{
				$newsblogTeaser = preg_replace("/.*<h[1-" . $cf['menu']['levels'] . ']' . $newsblogEntry_headingclass . '>/isU', '<' . $plugin_cf['newsblog']['use_headlines'] . '><a href="?' . $su . '___' . uenc($h[$idExtension]) . '&amp;nbfirst=' . $nbfirst . '&amp;nbcat=' . uenc($newsblogCategory) . '">', $newsblogTeaser);
				$newsblogTeaser = preg_replace("/<\/h[1-" . $cf['menu']['levels'] . ']>/isU', '</a></' . $plugin_cf['newsblog']['use_headlines'] . '>', $newsblogTeaser);
			}
			else
			{
				$newsblogTeaser = preg_replace("/.*<h[1-".$cf['menu']['levels'].']' . $newsblogEntry_headingclass . '>/isU', '<' . $plugin_cf['newsblog']['use_headlines'] . '>', $newsblogTeaser);
				$newsblogTeaser = preg_replace("/<\/h[1-".$cf['menu']['levels']."]>/isU", '</' . $plugin_cf['newsblog']['use_headlines'] . '>', $newsblogTeaser);
			}
			
			$newsblogTeaser = preg_replace("/{{{function(.*)}}}/isU", '', $newsblogTeaser);
			$newsblogTeaser = str_replace('<div></div>
', '', $newsblogTeaser);
			$newsblogTeaser = evaluate_scripting(preg_replace("/<hr(.*)/is", '', $newsblogTeaser));
			
			// output teasers
			if($key > ($nbfirst -2) && $key < $nblast)
			{
				$o.= "\n" . '<div class="newsblogEntry">' . "\n";
				$o.= $newsblogTeaser;

				// Read More link
				if(strstr($c[$idExtension],'<hr') || $adm)
				{
					$o.= '<p class="newsblogReadMore"><a href="?' . $su . '___' . uenc($h[$idExtension]) . '&amp;nbfirst=' . $nbfirst . '&amp;nbcat=' . uenc($newsblogCategory) . '">' . $plugin_tx['newsblog']['navi_read_more'] . '</a></p>';
				}
				
				$o.= "\n" . '</div>' . "\n";
			}
		}
		
		$o.= '</div>' . "\n\n";
		$o.= '<div class="newsblogAreaClearer"></div>' . "\n\n";
		
		// output page navigation and counter
		$o.= newsblogPageNav();
		$o.= newsblogCounter();
	}
	return $o;
}



function newsblogArticle()
{
	global $h,$s,$cf,$plugin_cf;

	if($cf['show']['page_headings'] != 'true' && $s >= 0) return('<' . $plugin_cf['newsblog']['use_headlines'] . '>' . $h[$s] . '<' . $plugin_cf['newsblog']['use_headlines'] . '>'); else return '';
}


function newsblogBL() // creates a backlink to blog overview, only visible in the article if called with {{{function: ... }}}
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	global $cf, $su, $plugin_tx, $nbfirst, $newsblogCategory;
	
	$urlArray = explode($cf['uri']['seperator'],$su );
	array_pop($urlArray);
	$url = implode($cf['uri']['seperator'],$urlArray);
	
	$o = '
<div class="newsblogBacklink"><a href="?' . $url . '&amp;nbfirst=' . $nbfirst . '&amp;nbcat=' . uenc($newsblogCategory) . '#newsblogTop">' . $plugin_tx['newsblog']['navi_back_to_overview'] . '</a></div>
';
	
	return $o;
}


function newsblogCOM($filename,$maprotected='false') // comments function, working only if Comments Plugin is installed
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	global $adm, $plugin_cf, $plugin_tx;
	
	if($adm && function_exists('comments') && $plugin_cf['newsblog']['show_edit_all_comments_link'] == 'true')
	{
		$o = '<div class="newsblogEditComments"><a href="?&comments&admin=plugin_main&action=plugin_text&selected=' . $filename . '.txt">' . $plugin_tx['newsblog']['navi_edit_comments'] . '</a></div>';
	}
	
	if(function_exists('comments'))
	{
		$o = comments($filename,$maprotected);
	}
	return $o;
}


function newsblogNOC($filename) // shows number of comments, only visible in blog overview
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	global $newsblogEntriesArray;

	if(isset($newsblogEntriesArray) && function_exists('comments_nr'))
	{
		if(comments_nr($filename) > 0) return "\n" . '<p class="newsblogNOC">' . comments_nr($filename) . '</p>' . "\n"; else return '';
	}
	else return '';
}


function newsblogCAT() // dummy function for categories
{
	return '';
}

?>