<?php

if (!function_exists('sv') || preg_match('#plugins/faqsimple/index.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

/*
============================================================
CMSimple Plugin FAQsimple
============================================================
Version:    FAQsimple 1.7
Released:   04/2022
Copyright:  Gert Ebersbach - www.ge-webdesign.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
utf-8 check: äöü 
*/

function faqsimple($closebutton='true',$showQuestionLabel='true',$showAnswerLabel='true',$faqpage='',$cssclass='default')
{
	global $u, $s, $cl, $l, $h, $c, $cf, $pth, $plugin_cf, $plugin_tx;

	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	$faqsimpleOutput = '';

	$ta = array();

	// for calling with no page call
	if($faqpage == '')
	{
		$sFaqSimple = $s;
	}
	else
	{
		$sFaqSimple = array_search($faqpage, $u);
	}

	if($sFaqSimple < 0) {$sFaqSimple = 0;}
	
	$tl = $l[$sFaqSimple] + 1 + $cf['menu']['levelcatch'];
	for ($i = $sFaqSimple + 1; $i < $cl; $i++) 
	{
		if ($l[$i] <= $l[$sFaqSimple]) 
		{
			break;
		}

		if ($l[$i] <= $tl) 
		{
			$ta[] = $i;
		}

		if ($l[$i] < $tl) 
		{
			$tl = $l[$i];
		}
	}

	if (count($ta) > 0) 
	{
		$faqsimpleOutput = "\n" . '<div class="faqsimple_area_' . $cssclass . '">' . "\n\n";
		foreach ($ta as $idExtension) 
		{
			$faqsimpleOutput.= '<div class="faqsimple_container">' . "\n";

			// Questions 

			if($showQuestionLabel == 'true' && $plugin_tx['faqsimple']['question'] != '')
			{
				$faqsimpleOutput.= '<p class="faqsimple_question_label">' . $plugin_tx['faqsimple']['question'] . '</p>' . "\n";
			}

			$showQuestionLabel == 'true' && $plugin_tx['faqsimple']['question'] == '' ? $faqsimpleQM = '<img src="./' . $pth['folder']['plugins'] . '/faqsimple/images/help_icon_' . $cssclass . '.png" alt="">&nbsp; ' : $faqsimpleQM = '';

			$faqsimpleOutput.= '<p class="faqsimple_question"  onclick="if(document.getElementById(\'answer' . $idExtension . '\').style.display == \'block\'){document.getElementById(\'answer' . $idExtension . '\').style.display = \'none\';} else {document.getElementById(\'answer' . $idExtension . '\').style.display = \'block\';}">' . $faqsimpleQM . '<a href="#id">' . $h[$idExtension] . '</a></p>' . "\n";

			// Answers 

			$faqsimple_answer = str_replace('#CMSimple hide#', '', $c[$idExtension]);

			if($showAnswerLabel == 'true')
			{
				$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '<p class="faqsimple_answer_label">' . $plugin_tx['faqsimple']['answer'] . '</p>', $faqsimple_answer);
			}
			else
			{
				$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '', $faqsimple_answer);
			}

			$faqsimpleOutput.= '<noscript>
<div class="faqsimple_noscript">' . $faqsimple_answer . '</div>
</noscript>
';
			$faqsimpleOutput.= '<div id="answer' . $idExtension . '" class="faqsimple_answer">' .  $faqsimple_answer;

			// Closebutton 

			if($closebutton == 'true') 
			{
				$faqsimpleOutput.= '<button type="submit" onclick="document.getElementById(\'answer' . $idExtension . '\').style.display = \'none\';">' . $plugin_tx['faqsimple']['close'] .'</button>' . "\n";
				$faqsimpleOutput.= '<div style="clear: both;"></div>' . "\n";
			}

			$faqsimpleOutput.= '</div>' . "\n";
			$faqsimpleOutput.= '</div>' . "\n\n";
		}

		$faqsimpleOutput.= '</div>' . "\n\n";
		$faqsimpleOutput = evaluate_scripting($faqsimpleOutput);
	}
	return $faqsimpleOutput;
}




// autoclose variant

function faqsimpleAuto($closebutton='true',$showQuestionLabel='true',$showAnswerLabel='true',$faqpage='',$cssclass='default')
{
	global $s, $cl, $l, $h, $u, $c, $cf, $pth, $plugin_cf, $plugin_tx;

	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	if($s>=0)
	{
		$faqsimplePagePath = $u[$s];
	}
	else
	{
		$faqsimplePagePath = '';
	}

	$faqsimpleOutput = '';

	$ta = array();

// for calling with no page call
	if($faqpage == '')
	{
		$sFaqSimple = $s;
	}
	else
	{
		$sFaqSimple = array_search($faqpage, $u);
	}

	if($sFaqSimple < 0) {$sFaqSimple = 0;}

	$tl = $l[$sFaqSimple] + 1 + $cf['menu']['levelcatch'];
	for ($i = $sFaqSimple + 1; $i < $cl; $i++) 
	{
		if ($l[$i] <= $l[$sFaqSimple]) 
		{
			break;
		}

		if ($l[$i] <= $tl) 
		{
			$ta[] = $i;
		}

		if ($l[$i] < $tl) 
		{
			$tl = $l[$i];
		}
	}

	if (count($ta) > 0) 
	{
		$faqsimpleOutput = '
<div id="faqsimple_id' . ($ta[0] - 2) . '" class="faqsimple_area_' . $cssclass . '">
<div id="faqsimple_id' . ($ta[0] - 1) . '"></div>
' . "\n";
		foreach ($ta as $idExtension) 
		{
			$faqsimpleOutput.= '<div id="faqsimple_id' . $idExtension . '" class="faqsimple_container">' . "\n";

			// Questions 

			if($showQuestionLabel == 'true' && $plugin_tx['faqsimple']['question'] != '')
			{
				$faqsimpleOutput.= '<p class="faqsimple_question_label">' . $plugin_tx['faqsimple']['question'] . '</p>' . "\n";
			}

			$showQuestionLabel == 'true' && $plugin_tx['faqsimple']['question'] == '' ? $faqsimpleQM = '<img src="./' . $pth['folder']['plugins'] . '/faqsimple/images/help_icon_' . $cssclass . '.png" alt="">&nbsp; ' : $faqsimpleQM = '';

			if(!isset($_REQUEST['faqid']) || $_REQUEST['faqid'] != $idExtension)
			{
				$faqsimpleOutput.= '<p class="faqsimple_question"><a href="./?' . $faqsimplePagePath . '&faqid=' . $idExtension . '#faqsimple_id' . ($idExtension-2) . '">' . $faqsimpleQM . $h[$idExtension] . '</a></p>' . "\n";
			}
			else
			{
				$faqsimpleOutput.= '<p class="faqsimple_question"><a href="./?' . $faqsimplePagePath . '#faqsimple_id' . ($idExtension-2) . '">' . $faqsimpleQM . $h[$idExtension] . '</a></p>' . "\n";
			}

			// Answers 

			$faqsimple_answer = str_replace('#CMSimple hide#', '', $c[$idExtension]);

			if($showAnswerLabel == 'true')
			{
				$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '<p class="faqsimple_answer_label">' . $plugin_tx['faqsimple']['answer'] . '</p>', $faqsimple_answer);
			}
			else
			{
				$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '', $faqsimple_answer);
			}

			if(isset($_REQUEST['faqid']) && $_REQUEST['faqid'] == $idExtension)
			{
				$faqsimpleOutput.= '<div id="answer' . $idExtension . '" class="faqsimple_answer_auto">' . "\n" .  $faqsimple_answer;


				// Closebutton 

				if($closebutton == 'true') 
				{
					$faqsimpleOutput.= '<a href="./?' . $faqsimplePagePath . '#faqsimple_id' . ($idExtension-2) . '"><div class="faqsimpleCloseButton">' . $plugin_tx['faqsimple']['close'] .'</div></a>' . "\n";
					$faqsimpleOutput.= '<div style="clear: both;"></div>' . "\n";
				}

				$faqsimpleOutput.= '</div>' . "\n";
			}
			$faqsimpleOutput.= '</div>' . "\n\n";
		}

		$faqsimpleOutput.= '</div>' . "\n\n";
		$faqsimpleOutput = evaluate_scripting($faqsimpleOutput);
	}
	return $faqsimpleOutput;
}




// faquick

function faquick($cssclass='default',$faqpage='')
{
	global $u, $s, $cl, $l, $h, $c, $cf, $pth, $plugin_cf, $plugin_tx;

	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	$faqsimpleOutput = '';

	$ta = array();

	// for calling with no page call
	if($faqpage == '')
	{
		$sFaqSimple = $s;
	}
	else
	{
		$sFaqSimple = array_search($faqpage, $u);
	}

	if($sFaqSimple < 0) {$sFaqSimple = 0;}

	$tl = $l[$sFaqSimple] + 1 + $cf['menu']['levelcatch'];
	for ($i = $sFaqSimple + 1; $i < $cl; $i++) 
	{
		if ($l[$i] <= $l[$sFaqSimple]) 
		{
			break;
		}

		if ($l[$i] <= $tl) 
		{
			$ta[] = $i;
		}

		if ($l[$i] < $tl) 
		{
			$tl = $l[$i];
		}
	}

	if (count($ta) > 0) 
	{
		$faqsimpleOutput = "\n" . '<div class="faqsimple_area_' . $cssclass . '">' . "\n\n";
		foreach ($ta as $idExtension) 
		{
			$faqsimpleOutput.= '<div class="faqsimple_container">' . "\n";

			// Questions 
			$faqsimpleQM = '<img src="./' . $pth['folder']['plugins'] . '/faqsimple/images/help_icon_' . $cssclass . '.png" alt="">&nbsp; ';
			$faqsimpleOutput.= '<p class="faqsimple_question"  onclick="if(document.getElementById(\'answer' . $idExtension . '\').style.display == \'block\'){document.getElementById(\'answer' . $idExtension . '\').style.display = \'none\';} else {document.getElementById(\'answer' . $idExtension . '\').style.display = \'block\';}">' . $faqsimpleQM . '<a href="#id">' . $h[$idExtension] . '</a></p>' . "\n";

			// Answers 
			$faqsimple_answer = str_replace('#CMSimple hide#', '', $c[$idExtension]);
			$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '', $faqsimple_answer);
			$faqsimpleOutput.= '<noscript>
<div class="faqsimple_noscript">' . $faqsimple_answer . '</div>
</noscript>
';
			$faqsimpleOutput.= '<div id="answer' . $idExtension . '" class="faqsimple_answer">' .  $faqsimple_answer;

			// Closebutton 
			$faqsimpleOutput.= '<button type="submit" onclick="document.getElementById(\'answer' . $idExtension . '\').style.display = \'none\';">' . $plugin_tx['faqsimple']['close'] .'</button>' . "\n";
			$faqsimpleOutput.= '<div style="clear: both;"></div>' . "\n";
			$faqsimpleOutput.= '</div>' . "\n";
			$faqsimpleOutput.= '</div>' . "\n\n";
		}

		$faqsimpleOutput.= '</div>' . "\n\n";
		$faqsimpleOutput = evaluate_scripting($faqsimpleOutput);
    }
	return $faqsimpleOutput;
}





// faquick autoclose variant

function faquickAuto($cssclass='default',$faqpage='')
{
	global $s, $cl, $l, $h, $u, $c, $cf, $pth, $plugin_cf, $plugin_tx;

	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}

	if($s>=0)
	{
		$faqsimplePagePath = $u[$s];
	}
	else
	{
		$faqsimplePagePath = '';
	}

	$faqsimpleOutput = '';

	$ta = array();

// for calling with no page call
	if($faqpage == '')
	{
		$sFaqSimple = $s;
	}
	else
	{
		$sFaqSimple = array_search($faqpage, $u);
	}

	if($sFaqSimple < 0) {$sFaqSimple = 0;}

	$tl = $l[$sFaqSimple] + 1 + $cf['menu']['levelcatch'];
	for ($i = $sFaqSimple + 1; $i < $cl; $i++) 
	{
		if ($l[$i] <= $l[$sFaqSimple]) 
		{
			break;
		}

		if ($l[$i] <= $tl) 
		{
			$ta[] = $i;
		}

		if ($l[$i] < $tl) 
		{
			$tl = $l[$i];
		}
	}

	if (count($ta) > 0) 
	{
		$faqsimpleOutput = '
<div id="faqsimple_id' . ($ta[0] - 2) . '" class="faqsimple_area_' . $cssclass . '">
<div id="faqsimple_id' . ($ta[0] - 1) . '"></div>
' . "\n";
		foreach ($ta as $idExtension) 
		{
			$faqsimpleOutput.= '<div id="faqsimple_id' . $idExtension . '" class="faqsimple_container">' . "\n";

			// Questions 
			$faqsimpleQM = '<img src="./' . $pth['folder']['plugins'] . '/faqsimple/images/help_icon_' . $cssclass . '.png" alt="">&nbsp; ';
			if(!isset($_REQUEST['faqid']) || $_REQUEST['faqid'] != $idExtension)
			{
				$faqsimpleOutput.= '<p class="faqsimple_question"><a href="./?' . $faqsimplePagePath . '&faqid=' . $idExtension . '#faqsimple_id' . ($idExtension-2) . '">' . $faqsimpleQM . $h[$idExtension] . '</a></p>' . "\n";
			}
			else
			{
				$faqsimpleOutput.= '<p class="faqsimple_question"><a href="./?' . $faqsimplePagePath . '#faqsimple_id' . ($idExtension-2) . '">' . $faqsimpleQM . $h[$idExtension] . '</a></p>' . "\n";
			}

			// Answers 
			$faqsimple_answer = str_replace('#CMSimple hide#', '', $c[$idExtension]);
			$faqsimple_answer = preg_replace("/.*<\/h[1-".$cf['menu']['levels']."]>/isU", '', $faqsimple_answer);
			if(isset($_REQUEST['faqid']) && $_REQUEST['faqid'] == $idExtension)
			{
				$faqsimpleOutput.= '<div id="answer' . $idExtension . '" class="faqsimple_answer_auto">' . "\n" .  $faqsimple_answer;


				// Closebutton 
				$faqsimpleOutput.= '<a href="./?' . $faqsimplePagePath . '#faqsimple_id' . ($idExtension-2) . '"><div class="faqsimpleCloseButton">' . $plugin_tx['faqsimple']['close'] .'</div></a>' . "\n";
				$faqsimpleOutput.= '<div style="clear: both;"></div>' . "\n";
				$faqsimpleOutput.= '</div>' . "\n";
			}
			$faqsimpleOutput.= '</div>' . "\n\n";
		}

		$faqsimpleOutput.= '</div>' . "\n\n";
		$faqsimpleOutput = evaluate_scripting($faqsimpleOutput);
	}
	return $faqsimpleOutput;
}
?>