<?php // utf-8 marker: äöü

/*
==========================================
Plugin BackupMail for CMSimple
Developed by: ge-webdesign.de
Version: BackupMail 2.0
Released: 2023-01
==========================================
License: Commercial License
see https://www.ge-webdesign.de/cmsimpleplugins/?terms_of_use
==========================================
*/

if (!function_exists('sv') || preg_match('#/plugins/backupmail/admin.php#i', $_SERVER['SCRIPT_NAME']))
{
	die('no direct access');
}

initvar('backupmail');
if ($backupmail) 
{
	if(!defined('CMSIMPLE_VERSION'))
	{
		$o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="https://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
		return;
	}
	
	if(defined('XH_ADM'))
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0;">
<h4><a href="?backupmail">Plugin Info &raquo;</a></h4>
<p style="line-height: 1.6em;"><b>BackupMail</b>&nbsp;by&nbsp;<a href="https://www.ge-webdesign.de/cmsimpleplugins/"><u>ge-webdesign.de&nbsp;&raquo;</u></a> &nbsp; 
for&nbsp;<b>CMSimple&nbsp;4.0</b>&nbsp;or&nbsp;higher&nbsp;from&nbsp;<a href="https://www.cmsimple.org/"><u>cmsimple.org&nbsp;&raquo;</u></a></p>
</div>';
	}
	else
	{
		$o.= '<div style="font-size: 15px; font-family: arial, sans-serif; letter-spacing: 0; padding: 0 0 6px 0;">
<b><a href="?backupmail">Plugin Info &raquo;</a></b>
</div>
';
	}
	
	// Make CMSimple variables accessible
	global $sn,$sv,$sl,$pth;
	
	global $plugin;
	
	// Detect the foldername of the plugin.
	$plugin=basename(dirname(__FILE__),"/");

	$admin = isset($_GET['admin']) ? $_GET['admin'] : '';
	$admin .= isset($_POST['admin']) ? $_POST['admin'] : '';

	// Parameter "ON"  shows the Plugin Main Tab.
	// Blank "" or "OFF" does not show the Plugin Main Tab.
	$o.=print_plugin_admin('ON');

	// First page when loading the plugin.
	if ($admin == '') 
	{
		$o.='
		<h4>Plugin BackupMail</h4>';
		
		$o .= '
		<div style="font-family: arial, sans-serif; font-size: 15px; letter-spacing: 0; border: 4px double; padding: 6px 16px; margin: 2px 0 8px 0;">
		<p style="text-align: center;">This Plugin is made for <a href="https://www.cmsimple.org/"><span style="font-weight: 700; padding: 0 6px; ">CMSimple 4.0 &raquo;</span></a> or higher.</p>
		<p style="text-align: center;">Optimized for <span style="font-weight: 700; padding: 0 6px; ">CMSimple 4.4</span> or higher.</p>
		<p style="text-align: center;">Recommended is the current version of CMSimple from <a href="https://www.cmsimple.org/">cmsimple.org&nbsp;&raquo;</a></p>
		</div>
		';
		
		$o.='<ul>
		<li>Version: BackupMail ' . BACKUPMAIL_VERSION . '</li>
		<li>Released: 2023-01</li>
		<li>Copyright: Gert Ebersbach</li>
		<li>Lizenz: <a href="https://www.ge-webdesign.de/cmsimpleplugins/?terms_of_use">Commercial License</a></li>
		<li>Internet: <a href="https://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins">www.ge-webdesign.de</a></li>
		</ul>
		<hr>
		<p><b>Credits:</b></p>
		<p>Andreas Skodzek - Script "zip on the fly"</p>
		<p>Nils Reimers - <a href="https://www.php-einfach.de/codeschnipsel_1114.php">php-einfach.de</a> (Script "Email mit Anhang")</p>
		';
	}

	if ($admin == 'plugin_main') 
	{
		$o.='
<h4>Plugin BackupMail</h4>
';

		if(isset($_POST['backupmail_files_textarea']))
		{
			$backupmail_handle = fopen($plugin_cf['backupmail']['data_file_files'],'w');
			fwrite($backupmail_handle, trim($_POST['backupmail_files_textarea']));
			fclose($backupmail_handle);

			$backupmail_handle = fopen($plugin_cf['backupmail']['data_file_folders'],'w');
			fwrite($backupmail_handle, trim($_POST['backupmail_folders_textarea']));
			fclose($backupmail_handle);
			$o.='<div class="cmsimplecore_warning" style="padding: 0; margin: 5px 0;">
<p style="text-align: center;">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_hint_files_saved']))) . '</p>
</div>
';
		}


// messages
		
		// both data files ampty
		if(isset($_POST['backupmail']) && file_get_contents($plugin_cf['backupmail']['data_file_files']) == '' && file_get_contents($plugin_cf['backupmail']['data_file_folders']) == '' && $_POST['bm_create_backup'])
		{
			$o.='
<div class="cmsimplecore_warning" style="padding: 0; margin: 5px 0;">
<p style="text-align: center;">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_datafiles_empty']))) . '</p>
</div>';
		}
		
		// success sent backupmail
		if(isset($_POST['bm_send_backupmail']))
		{
				$o.='
<div class="cmsimplecore_warning" style="padding: 0; margin: 5px 0;">
<p style="text-align: center;">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['success_mail_sent']))) . '</p>
</div>';
		}
		
		// success created backup
		if(isset($_POST['bm_create_backup']) && (file_get_contents($plugin_cf['backupmail']['data_file_files']) != '' || file_get_contents($plugin_cf['backupmail']['data_file_folders'])) != '')
		{
			$o.='
<div class="cmsimplecore_warning" style="padding: 0; margin: 5px 0;">
<p style="text-align: center;">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['success_backup_created']))) . '</p>
</div>';
		}


// Links above textareas

		if(!isset($_REQUEST['backupmail_form']) && !isset($_POST['backupmail']))
		{
			$o.='
<hr>
<p style="margin: 10px 0 0 0;"><a href="./?&backupmail&admin=plugin_main&action=plugin_text&backupmail_form&normal">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_link_to_mailform']))) . '</a></p>
';
		}
		
		createZipfilesArray();
		
		if(count($backupmail_zipfiles) > 0 && !isset($_REQUEST['backupmail_form']) && !isset($_POST['backupmail']))
		{
			$o.='
<p style="margin: 10px 0 0 0;"><a href="' . $plugin_cf['backupmail']['data_path_zipfiles'] . $backupmail_zipfiles[count($backupmail_zipfiles) - 1] . '">' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_backup_download']))) . '</a></p>
	';
		}


// Main Settings Form
		
		if(!isset($_REQUEST['backupmail_form']))
		{
			$o.='<hr>
<form id="backupmail_files" name="backupmail_files" action="#" method="post">
' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_hint1']))) . '
<h4>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_files']))) . '</h4>
<p><b>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_example']))) . '</b></p>
<p style="font-family: courier new, monospace; font-size: 16px;">./content/content.php<br>./content/pagedata.php</p>
<textarea id="backupmail_files_textarea" name="backupmail_files_textarea" style="width: 96%; height: 160px; font-family: courier new, monospace;">
' . file_get_contents($plugin_cf['backupmail']['data_file_files']) . '
</textarea>';

			if($plugin_cf['backupmail']['create_zip_files'])
			{
				$o.='<h4>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_folders']))) . '</h4>
<p><b>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['admin_example']))) . '</b></p>
<p style="font-family: courier new, monospace; font-size: 16px;">./content/comments/<br>./content/realblog/</p>
<textarea id="backupmail_folders_textarea" name="backupmail_folders_textarea" style="width: 96%; height: 160px; font-family: courier new, monospace;">
' . file_get_contents($plugin_cf['backupmail']['data_file_folders']) . '
</textarea>';
			}
			
			$o.='<input style="clear: both; margin-top: 10px;" type="submit" name="submit" value="' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_submit_backup_mail']))) . '">
</form>';
		}

		if(isset($_POST['bm_create_backup']))
		{
			createBackupZipArray();
			if($plugin_cf['backupmail']['create_zip_files'] == 'true')
			{
				createBackupZip(); // only if zip is activated
			}
			// delete oldest zip file
			if(count($backupmail_zipfiles) >= $plugin_cf['backupmail']['number_of_zipfiles'])
			{
				createZipfilesArray();
				deleteBackupZip();
			}
		}
	}


// BackupMail form 

	if(($plugin_cf['backupmail']['create_and_send_mail'] == 'true' || $plugin_cf['backupmail']['create_zip_files'] == 'true') && isset($_REQUEST['backupmail_form']))
	{
		if(!isset($_POST['backupmail']))
		{
			$o .= '
<div id="backupmail_main_backend">
<form id="bm_login" name="bm_login" action="./?&backupmail&admin=plugin_main&action=plugin_text" method="post">
';

			$o .= '<p><input type="checkbox" name="bm_create_backup" value="bm_create_backup" checked="checked"> &nbsp;' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_checkbox_backup']))) . '</p>';

			if($plugin_cf['backupmail']['create_and_send_mail'] == 'true')
			{
				$o .= '<p><input type="checkbox" name="bm_send_backupmail" id="bm_send_backupmail" value="bm_send_backupmail" checked="checked"> &nbsp;' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_checkbox_mail']))) . '</p>';
			}
			
			if($plugin_cf['backupmail']['show_inputfield_author'] == 'true')
			{
				$o .= '<p>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_author']))) . '</p>' . "\n"
 . tag('input class="bm_input" type="text" name="bm_author" id="bm_author" value=""') . "\n";
			}
	 
			if($plugin_cf['backupmail']['show_textarea_notice'] == 'true')
			{
				$o .= '<p>' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_short_notice']))) . '</p>' . "\n"
 . '<textarea class="bm_textarea" name="bm_textarea" id="bm_textarea">...</textarea>' . "\n";
			}
			
			$o .= tag('input class="bm_input" type="hidden" name="backupmail" id="backupmail" value="true"') . "\n"
 . tag('input style="clear: both; padding: 1px 5px 2px 5px; margin-top: 10px;" type="submit" name="submit" value="' . str_replace('<br><br><br><br>','<br><br>', str_replace("\r",'<br>',str_replace("\n",'<br>',$plugin_tx['backupmail']['mailform_submit_backup_mail']))) . '"') . '
</form>
</div>
';
		}
	}

	if(isset($_POST['backupmail']) && $_POST['backupmail'] == 'true')
	{
		createBackupZipArray();
		createZipfilesArray();
		bmPrepareMaildata();
		bmSendBackupMail();
	}
	
	
	if ($admin <> 'plugin_main') 
	{
		$hint=array();
		$hint['mode_donotshowvarnames'] = false;
		$o.=plugin_admin_common($action, $admin, $plugin, $hint);
	}
}

?>