<?php 

/*
============================================================
CMSimple Plugin TableSort
============================================================
Version:    TableSort 3.0
Released:   03/2022
Copyright:  Gert Ebersbach
Author:		Gert Ebersbach - www.ge-webdesign.de
============================================================ 
utf-8 marker: äöü 
*/

// ########## TABLESORT ##########

function tablesort($ge_ts_presort='presort',$ge_ts_presort_col='0',$ge_ts_presort_dir='1')
{
	global $plugin_cf, $plugin_tx, $cf, $sl, $sn, $pth;
	
	if(!defined('CMSIMPLE_VERSION'))
	{
		return '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
	}
	
	$tso= '
<script src="' . $pth['folder']['base'] . 'plugins/tablesort/js/sort_table.js"></script>
<script src="' . $pth['folder']['base'] . 'plugins/tablesort/js/ltrim.js"></script>
<script>
if (!Array.prototype.forEach)
{
Array.prototype.forEach = function(fun /*, thisp*/)
{
var len = this.length >>> 0;
if (typeof fun != "function")
throw new TypeError();
var thisp = arguments[1];
for (var i = 0; i < len; i++)
{
if (i in this)
fun.call(thisp, this[i], i, this);
}
};
}

// Das Element das angezeigt wird, wenn die Spalte abwärts sortiert ist
SortTable.up = "'.tag('br').'" + String.fromCharCode(9650);
SortTable.alt_up = "' . $plugin_tx['tablesort']['tooltip_sort'] . '";

// Das Element das angezeigt wird, wenn die Spalte aufwärts sortiert ist
SortTable.down = "'.tag('br').'" + String.fromCharCode(9660);
SortTable.alt_down = "' . $plugin_tx['tablesort']['tooltip_sort'] . '";

// Farbe des Zeichens in der Spaltenüberschrift
SortTable.pointer_color = "' . $plugin_cf['tablesort']['arrow_color'] . '";

// Die Bezeichnung der Klasse der Tabellen, die sortiert werden sollen
SortTable.className = "sortable";

/*
	Zebratabelle (c) 2008 J. Strübig
	http://javascript.jstruebig.de/js/zebratabelle.html
*/

function ZebraTabelle(t) {
	var obj = t;
	var rows = [];
	var self = this;
	var hasBody = !!t.getElementsByTagName("tbody").length;
	var body = t.getElementsByTagName("tbody").length ? t.getElementsByTagName("tbody")[0] : t;
	var rows = body.getElementsByTagName("tr");

	for(var i = 1; i < rows.length; i += 2) rows[i].className += " odd";
}

ZebraTabelle.init = function() {

	// Alle Tabellen des Dokuments

	var t = document.getElementsByTagName("table");
	var r = /\bzebra\b/i;

	for(var i = 0; i < t.length; i++) {
		if(t[i].className && r.test(t[i].className) ) {
			var tmp = new ZebraTabelle(t[i]);
		}
	}
};
ZebraTabelle.init();
';
	if($ge_ts_presort=='presort')
	{
		$tso.='SortTable.init().forEach(function(el) {el.sort(' . $ge_ts_presort_col . ', ' . $ge_ts_presort_dir . ');})';
	}
	else
	{
		$tso.='SortTable.init();';
	}
$tso.='
</script>
';

	return ($tso);
}
?>