<?php

// utf-8 marker: äöü

if (!function_exists('sv') || preg_match('#/plugins/subsitefuncs/index.php#i', $_SERVER['SCRIPT_NAME']))
{
    die('no direct access');
}

/*
============================================================ 
CMSimple Plugin SubsiteFuncs
============================================================ 
Version:    SubsiteFuncs 2.6
Released:   2025-11
Copyright:  Gert Ebersbach - www.ge-webdesign.de
Authors:    Gert Ebersbach - www.ge-webdesign.de
            Martin Damken - www.zeichenkombinat.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
*/

$plugin = 'subsitefuncs';

$ssf_subsitesDataPath = $pth['folder']['base'] . $plugin_cf['subsitefuncs']['data_path'];

$ssf_subsitesArray = array();
$ssf_subsitesGroupsArray = array();
$ssf_subsitesGroupsNamesArray = array();
$ssf_subarrays = array();
$ssf_subsitesDataArray = array();

$hjs .= '<link href="' . CMSIMPLE_ROOT . 'plugins/subsitefuncs/includes/assets/styles.css" rel="stylesheet">';
$hjs .= '<script src="' . CMSIMPLE_ROOT . 'plugins/subsitefuncs/includes/assets/toggler.js"></script>';

if(!function_exists('mb_strtolower')) 
{
	function mb_strtolower($string, $charset = null) 
	{
		$string = utf8_decode($string);
		$string = strtolower($string);
		$string = utf8_encode($string);
		return $string;
	}
}


// Subsite Groups Arrays erzeugen

if ($plugin_cf['subsitefuncs']['groups'] != '')
{
    $ssf_subsitesGroupsArray = explode('|', $plugin_cf['subsitefuncs']['groups']);
}

if ($plugin_cf['subsitefuncs']['groups_names'] != '' && isset($ssf_subsitesGroupsArray))
{
    $ssf_subsitesGroupsNamesArray = explode('|', $plugin_cf['subsitefuncs']['groups_names']);
} else
{
    $ssf_subsitesGroupsNamesArray = $ssf_subsitesGroupsArray;
}


// Datendatei zeilenweise als Array einlesen

$ssf_subarrays = file($ssf_subsitesDataPath);


// Assoziatives zweidimensionales Array für Subsites Daten "$ssf_subsitesDataArray" erzeugen

foreach ($ssf_subarrays as $key => $subarray)
{
    $tempArray = explode('|', $subarray);

    $ssf_subsitesDataArray[$tempArray[0]]['folder'] = trim($tempArray[0]);
    $ssf_subsitesDataArray[$tempArray[0]]['name']   = trim($tempArray[1]);
    $ssf_subsitesDataArray[$tempArray[0]]['group']  = trim($tempArray[2]);
}


// Automatische Subsites Erkennung - Array aller vorhandenen Subsites 

$ssf_allSubsitesArray = array();

$ssfHandle         = opendir($pth['folder']['base']);
while (($ssfSubsite        = readdir($ssfHandle)) == true)
{
    if ($ssfSubsite != '..' && $ssfSubsite != '.' && is_dir($pth['folder']['base'] . $ssfSubsite))
    {
        if (file_exists($pth['folder']['base'] . $ssfSubsite . '/cmsimplesubsite.htm'))
        {
            $ssf_allSubsitesArray[] = $ssfSubsite;
        }
    }
}
closedir($ssfHandle);

if(count($ssf_allSubsitesArray)>1)sort($ssf_allSubsitesArray);


// Subsites Array "$ssf_subsitesArray" erzeugen

foreach ($ssf_subarrays as $key => $temp)
{
	$tempArray = explode('|', $temp);
	
	if(file_exists($pth['folder']['base'] . $tempArray[0] . '/cmsimplesubsite.htm') && isset($ssf_subsitesDataArray[$tempArray[0]]['group']))
	{
		$ssf_subsitesArray[] = $tempArray[0];
	}
}


// Aktuelle Subsite ermitteln

$currentSubsiteFolderNameArray = explode('/', $sn);
$currentSubsiteFolderName      = array_pop($currentSubsiteFolderNameArray);
$currentSubsiteFolderName      = array_pop($currentSubsiteFolderNameArray);

if($pth['folder']['base'] == './') $currentSubsiteFolderName = '';

if($pth['folder']['base'] == './')
{
	$currentSubsiteFolderPath = '';
}
else
{
	$currentSubsiteFolderPath = $currentSubsiteFolderName . '/';
}


// extensions Schnittstelle

if(file_exists($pth['folder']['base'] . 'plugins/subsitefuncs/extensions/extensions.php'))
{
	include($pth['folder']['base'] . 'plugins/subsitefuncs/extensions/extensions.php');
}

if(file_exists($pth['folder']['base'] . 'plugins/subsitefuncs/extensions/extensions.css'))
{
	$hjs.='<link rel="stylesheet" href="' . $pth['folder']['base'] . 'plugins/subsitefuncs/extensions/extensions.css" type="text/css">';
}



/*
#############################
F U N K T I O N E N
#############################
 */

function ssf_subsitesMenu($ssfGroup = 'all', $ssfMainSite = 'true', $ssfMenuClass = 'default')
{
    global $sn, $pth, $plugin_cf, $ssf_subsitesArray, $currentSubsiteFolderName, $ssf_subsitesDataArray;

    if (!defined('CMSIMPLE_VERSION'))
    {
        $o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
        return;
    }

    $output = '<div class="ssf_subsitesMenuContainer_' . $ssfMenuClass . '">
<ul>' . "\n";

    if ($ssfMainSite == 'true')
    {
        if ($pth['folder']['base'] == './')
        {
            $output.= '<li class="ssf_currentSubsite ssf_mainsite"><span>' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</span></li>' . "\n";
        } 
        else
        {
            $output.= '<li class="ssf_otherSubsite ssf_mainsite"><a href="' . $pth['folder']['base'] . '">' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</a></li>' . "\n";
        }
    }

    if ($ssfGroup == 'all')
    {
        foreach ($ssf_subsitesArray as $key => $subsitesMenuItem)
        {
            $subsitesMenuItem = trim($subsitesMenuItem);

            if (file_exists($pth['folder']['base'] . $subsitesMenuItem . '/cmsimplesubsite.htm'))
            {
                if ($subsitesMenuItem == $currentSubsiteFolderName)
                {
                    $output.= '<li class="ssf_currentSubsite ssf_' . $subsitesMenuItem . '"><span>' . $ssf_subsitesDataArray[$subsitesMenuItem]['name'] . '</span></li>' . "\n";
                } else
                {
                    $output.= '<li class="ssf_otherSubsite ssf_' . $subsitesMenuItem . '"><a href="' . $pth['folder']['base'] . $subsitesMenuItem . '">' . $ssf_subsitesDataArray[$subsitesMenuItem]['name'] . '</a></li>' . "\n";
                }
            }
        }
    } 
	else
    {
        foreach ($ssf_subsitesArray as $key => $subsitesMenuItem)
        {
            $subsitesMenuItem = trim($subsitesMenuItem);

            if (file_exists($pth['folder']['base'] . $subsitesMenuItem . '/cmsimplesubsite.htm') && $ssf_subsitesDataArray[$subsitesMenuItem]['group'] == $ssfGroup)
            {
                if ($subsitesMenuItem == $currentSubsiteFolderName)
                {
                    $output.= '<li class="ssf_currentSubsite ssf_' . $subsitesMenuItem . '"><span>' . $ssf_subsitesDataArray[$subsitesMenuItem]['name'] . '</span></li>' . "\n";
                } 
                else
                {
                    $output.= '<li class="ssf_otherSubsite ssf_' . $subsitesMenuItem . '"><a href="' . $pth['folder']['base'] . $subsitesMenuItem . '">' . $ssf_subsitesDataArray[$subsitesMenuItem]['name'] . '</a></li>' . "\n";
                }
            }
        }
    }
    $output.= '</ul>' . "\n" . '</div>
<div style="clear: both;"></div>' . "\n";

    return $output;
}



function ssf_groupsMenuJS1($ssf_groupsMenuClass = 'default', $ssf_groupsMenuClassExtension = '', $ssf_groupsMenuHightClosed = '36px')
{
    global $pth, $plugin_cf, $ssf_subsitesGroupsArray, $ssf_subsitesGroupsNamesArray, $ssf_subsitesDataArray, $currentSubsiteFolderName;

    if (!defined('CMSIMPLE_VERSION'))
    {
        $o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
        return;
    }

    $output = '<div class="ssf_subsiteGroupsMenuContainer_' . $ssf_groupsMenuClass . '">' . "\n";

    // Hauptseite
    if ($pth['folder']['base'] != './')
    {
        $output.= '
<div class="subsiteGroupsMenu_home">
<p><b><a href="' . $pth['folder']['base'] . '">' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</a></b></p>
</div>
';
    } else
    {
        $output.= '
<div class="subsiteGroupsMenu_homeCurrent">
<p><b>' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</b></p>
</div>
';
    }

    // Gruppenmenüs
    if (isset($ssf_subsitesGroupsArray))
    {
        foreach ($ssf_subsitesGroupsArray as $key => $subsitesGroupMenuItem)
        {
            if (isset($ssf_subsitesDataArray[$currentSubsiteFolderName]['group']) && $ssf_subsitesDataArray[$currentSubsiteFolderName]['group'] == $subsitesGroupMenuItem)
            {
                $output.= '
<div class="subsiteCurrentGroupMenuJS1 ssf_allGroups' . $ssf_groupsMenuClassExtension . '">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>
';
            } else
            {
                $output.= '
<div class="subsiteGroupsMenuJS1 ssf_allGroups' . $ssf_groupsMenuClassExtension . '" onclick="
if(style.height==\'\' || style.height==\'' . $ssf_groupsMenuHightClosed . '\')
{style.height=\'auto\';style.background=\'url(' . $pth['folder']['plugins'] . 'subsitefuncs/images/' . $plugin_cf['subsitefuncs']['menus_icon_close'] . ') top right no-repeat\'}
else
{style.height=\'' . $ssf_groupsMenuHightClosed . '\';style.background=\'url(' . $pth['folder']['plugins'] . 'subsitefuncs/images/' . $plugin_cf['subsitefuncs']['menus_icon_open'] . ') top right no-repeat\'}">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>
';
            }
            $output.= '
<script>
document.getElementsByClassName("ssf_allGroups' . $ssf_groupsMenuClassExtension . '")[' . $key . '].style.height="' . $ssf_groupsMenuHightClosed . '";
document.getElementsByClassName("ssf_allGroups' . $ssf_groupsMenuClassExtension . '")[' . $key . '].style.background=\'url(' . $pth['folder']['plugins'] . 'subsitefuncs/images/' . $plugin_cf['subsitefuncs']['menus_icon_open'] . ') top right no-repeat\';
</script>
';
        }
    }
    $output.= "\n" . '</div>' . "\n";
    return $output;
}



function ssf_groupsMenuJS2($ssf_groupsMenuClass = 'default', $ssf_groupsMenuIdExtension = '', $ssf_groupsMenuHightClosed = '36px')
{
    global $pth, $plugin_cf, $ssf_subsitesGroupsArray, $ssf_subsitesGroupsNamesArray, $ssf_subsitesDataArray, $currentSubsiteFolderName;

    if (!defined('CMSIMPLE_VERSION'))
    {
        $o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
        return;
    }

    $output = '<div class="ssf_subsiteGroupsMenuContainer_' . $ssf_groupsMenuClass . '">' . "\n";

    // Hauptseite
    if ($pth['folder']['base'] != './')
    {
        $output.= '
<div class="subsiteGroupsMenu_home">
<p><b><a href="' . $pth['folder']['base'] . '">' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</a></b></p>
</div>
';
    } 
	else
    {
        $output.= '
<div class="subsiteGroupsMenu_homeCurrent" onclick="window.location.reload();">
<p><b>' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</b></p>
</div>
';
    }

    // Gruppenmenüs
    if (isset($ssf_subsitesGroupsArray))
    {
        foreach ($ssf_subsitesGroupsArray as $key => $subsitesGroupMenuItem)
        {
            if (isset($ssf_subsitesDataArray[$currentSubsiteFolderName]['group']) && $ssf_subsitesDataArray[$currentSubsiteFolderName]['group'] == $subsitesGroupMenuItem)
            {
                $output.= '
<div id="ssf_' . $subsitesGroupMenuItem . $ssf_groupsMenuIdExtension . '" class="subsiteGroupsMenuJS2 subsiteCurrentGroupMenuJS2" onclick="' . "\n";

                foreach ($ssf_subsitesGroupsArray as $element)
                {
                    $output.= 'document.getElementById(\'ssf_' . $element . $ssf_groupsMenuIdExtension . '\').style.height=\'' . $ssf_groupsMenuHightClosed . '\';' . "\n";
                }

                $output.= 'style.height=\'auto\'">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>
';
            } else
            {
                $output.= '
<div id="ssf_' . $subsitesGroupMenuItem . $ssf_groupsMenuIdExtension . '" class="subsiteGroupsMenuJS2" onclick="' . "\n";

                foreach ($ssf_subsitesGroupsArray as $element)
                {
                    $output.= 'document.getElementById(\'ssf_' . $element . $ssf_groupsMenuIdExtension . '\').style.height=\'' . $ssf_groupsMenuHightClosed . '\';' . "\n";
                }

                $output.= 'style.height=\'auto\'">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>' . "\n";
            }

            if (!isset($ssf_subsitesDataArray[$currentSubsiteFolderName]['group'])) $ssf_subsitesDataArray[$currentSubsiteFolderName]['group'] = '';
			if ($ssf_subsitesDataArray[$currentSubsiteFolderName]['group'] != $subsitesGroupMenuItem)
            {
                $output.= '
<script>
document.getElementById("ssf_' . $subsitesGroupMenuItem . $ssf_groupsMenuIdExtension . '").style.height="' . $ssf_groupsMenuHightClosed . '";
document.getElementById("ssf_' . $subsitesGroupMenuItem . $ssf_groupsMenuIdExtension . '").style.background=\'url(' . $pth['folder']['plugins'] . 'subsitefuncs/images/' . $plugin_cf['subsitefuncs']['menus_icon_open'] . ') top right no-repeat\';
</script>
';
            }
        }
    }
    $output.= "\n" . '</div>' . "\n";
    return $output;
}



function ssf_groupsMenuOpen($ssf_groupsMenuClass = 'default')
{
    global $pth, $plugin_cf, $ssf_subsitesGroupsArray, $ssf_subsitesGroupsNamesArray, $ssf_subsitesDataArray, $currentSubsiteFolderName;

    if (!defined('CMSIMPLE_VERSION'))
    {
        $o.= '<p>This plugin requires <b>CMSimple 4.2</b> or higher.</p><p><a href="http://www.cmsimple.org/">CMSimple Download & Updates &raquo;</a></p>';
        return;
    }

    $output = '<div class="ssf_subsiteGroupsMenuContainer_' . $ssf_groupsMenuClass . '">' . "\n";

    // Hauptseite
    if ($pth['folder']['base'] != './')
    {
        $output.= '
<div class="subsiteGroupsMenu_home">
<p><b><a href="' . $pth['folder']['base'] . '">' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</a></b></p>
</div>
';
    } else
    {
        $output.= '
<div class="subsiteGroupsMenu_homeCurrent">
<p><b>' . $plugin_cf['subsitefuncs']['mainsite_name'] . '</b></p>
</div>
';
    }

    // Gruppenmenüs
    if (isset($ssf_subsitesGroupsArray))
    {
        foreach ($ssf_subsitesGroupsArray as $key => $subsitesGroupMenuItem)
        {
            if (isset($ssf_subsitesDataArray[$currentSubsiteFolderName]['group']) && $ssf_subsitesDataArray[$currentSubsiteFolderName]['group'] == $subsitesGroupMenuItem)
            {
                $output.= '
<div class="subsiteCurrentGroupMenuOpen">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>
';
            } 
			else
            {
                $output.= '
<div class="subsiteGroupsMenuOpen">
<p><b>' . $ssf_subsitesGroupsNamesArray[$key] . '</b></p>
' . ssf_subsitesMenu($subsitesGroupMenuItem, '', $ssf_groupsMenuClass) . '</div>
';
            }
        }
    }
    $output.= "\n" . '</div>' . "\n";
    return $output;
}



// SITEMAP & SEARCH

require 'includes/bootstrap.php';
$ssfPresenter = new SsfPresenter($plugin_cf['subsitefuncs'], $cf, $ssf_subsitesDataArray); 


// SITEMAP

if ($f === 'sitemap' && $plugin_cf['subsitefuncs']['sitemap_subsites'] == 'true' && count($ssf_subsitesArray) > 0)
{
    $f = '';
	$title = $tx['title']['sitemap'];
    $o .= '<h4>' . $tx['title']['sitemap'] . ':</h4><br>';

	$o.= $plugin_cf['subsitefuncs']['sitemap_groups'] == 'true' ? $ssfPresenter->groupedPageTree($CMSimple4menulevel, $plugin_cf['subsitefuncs']['sitemap_show_hidden_pages'], true) : $ssfPresenter->pageTree($CMSimple4menulevel, $plugin_cf['subsitefuncs']['sitemap_show_hidden_pages']);
	
	if($plugin_cf['subsitefuncs']['sitemap_dynamic'] == 'true')
	{
		if($plugin_cf['subsitefuncs']['sitemap_only_one_item_open'] == 'true')
		{
			$o.= "\n" . '<script>SsfToggler.initauto(".results-container > .toggler",true,';
			$o.= $plugin_cf['subsitefuncs']['sitemap_open_current'] == "true" ? "true" : "false";
			$o.= ',true);</script>' . "\n";
		}
		else
		{
			$o.= "\n" . '<script>SsfToggler.init(".results-container > .toggler",true,true,false);</script>' . "\n";
		}
	}
}


// SEARCH

if ($f === 'search' && $plugin_cf['subsitefuncs']['search_subsites'] == 'true')
{
	$f = '';
	$title = $tx['search']['result'];
	$o .= '<h1>' . $tx['search']['result'] . '</h1>';

	if($search != '')
	{
		$ssf_search_result = $ssfPresenter->search();

		$info = '"' . htmlspecialchars(filter_input(INPUT_GET, 'search'), ENT_COMPAT, 'UTF-8') . '" ';

		switch ($ssf_search_result['count'])
		{
			case 0:
				$info .= $tx['search']['notfound'] . '.';
				break;
			case 1:
				$info .= $tx['search']['foundin'] . " {$ssf_search_result['count']} " . $tx['search']['pgsingular'] . ':';
				break;
			default:
				$info .= $tx['search']['foundin'] . " {$ssf_search_result['count']} " . $tx['search']['pgplural'] . ':';
		}
	}
	else 
	{
		$o .= '<p>"" ' . $tx['search']['notfound'] . '</p>';
	}
	$o .= "<p>$info</p>";
	$o .= $ssf_search_result['html'];
}

if ($plugin_cf['subsitefuncs']['use_cache'] != 'true' && file_exists('./content/cache.php'))
{
	unlink('./content/cache.php');
}

?>