<?php // utf-8 marker: äöü

/*
============================================================ 
CMSimple Plugin SubsiteFuncs
============================================================ 
Version:    SubsiteFuncs 2.5
Released:   2023-07
Copyright:  Gert Ebersbach - www.ge-webdesign.de
Authors:    Gert Ebersbach - www.ge-webdesign.de
            Martin Damken - www.zeichenkombinat.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
*/

class SsfView
{

    protected $file     = NULL;
    protected $params   = array();
    protected $viewsDir = '';

    public function __construct($dir)
    {
        $this->viewsDir = $dir;
    }

    public function setFile($file)
    {
        $this->file = realpath("{$this->viewsDir}/{$file}");
        return $this;
    }

    public function setParam($key, $value, $escape = TRUE)
    {
        if (is_string($key))
        {
            if ($escape && is_string($value))
            {
                $value = htmlspecialchars($value);
            }
            $this->params[$key] = $value;
        }
        return $this;
    }

    public function setParams(array $array)
    {
        if (is_array($array))
        {
            foreach ($array as $key => $value)
            {
                $this->setParam($key, $value);
            }
        }
        return $this;
    }

    public function render()
    {
        if (!$this->file)
        {
            return 'No template found';
        }
        ob_start();
        extract($this->params);
        include $this->file;
        $this->params = array();

        return ob_get_clean();
    }

    public function send()
    {
        echo $this->render();
    }

    public function dumpParams()
    {
        echo '<pre>' . print_r($this->params, TRUE) . '</pre>';
    }

    public function dumpParam($key)
    {
        echo '<pre>' . print_r($this->params[$key], TRUE) . '</pre>';
    }

}
