<?php // utf-8 marker: äöü

/*
============================================================ 
CMSimple Plugin SubsiteFuncs
============================================================ 
Version:    SubsiteFuncs 2.6
Released:   2025-11
Copyright:  Gert Ebersbach - www.ge-webdesign.de
Authors:    Gert Ebersbach - www.ge-webdesign.de
            Martin Damken - www.zeichenkombinat.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
*/

class Site
{
    protected $baseLink    = '';
    protected $dir         = '';
    protected $contentDir  = '';
    protected $contentFile = NULL;
    protected $dataFile    = NULL;
    protected $cacheFile   = NULL;
    protected $pageData    = array();
    protected $menuLevels  = 3;
    protected $separator   = '/';
    protected $rxScript    = NULL;
    protected $pages       = array();
    protected $name        = '';
    protected $group       = '';
    protected $groupName   = '';

    public function __construct($settings = array())
    {
        global $CMSimple4menulevel;
		$this->dir        = realpath($settings['dir']);
        $this->contentDir = is_dir($this->dir . '/content')
                ? $this->dir . '/content'
                : $this->dir;

        if (realpath($this->contentFile = $this->contentDir . '/content.php'))
        {
            $this->contentFile = $this->contentDir . '/content.php';
            $this->dataFile    = $this->contentDir . '/pagedata.php';
            $this->cacheFile   = $this->contentDir . '/cache.php';

            $this->baseLink = rtrim($settings['dir'], '/') . '/';

            $this->name      = !empty($settings['name'])
                    ? $settings['name']
                    : '';
            $this->group     = !empty($settings['group'])
                    ? $settings['group']
                    : FALSE;
            $this->groupName = !empty($settings['groupName'])
                    ? $settings['groupName']
                    : '';

            $cf              = array();
            $localConfigFile = realpath($this->dir . '/config.php');

            if ($localConfigFile)
            {
                include $localConfigFile;
            }

            $this->separator  = !empty($cf['uri']['seperator'])
                    ? $cf['uri']['seperator']
                    : $settings['separator'];
            $this->menuLevels = $CMSimple4menulevel;

            $this->rxScript = $settings['rxScript'];

            $this->load();
        }
    }

    protected function load()
    {
        global $plugin_cf, $cf;

		if (
                file_exists($this->cacheFile)
                && filemtime($this->contentFile) < filemtime($this->cacheFile)
                && filemtime($this->dataFile) < filemtime($this->cacheFile)
				&& $plugin_cf['subsitefuncs']['use_cache'] == 'true'
        )
        {
            $this->pages = include $this->cacheFile;
            return;
        }

        $temp = file_get_contents($this->contentFile);

        include $this->dataFile;

        if($cf['use']['h1only_pagesplitting'] == 'true')
		{
			$contents = preg_split('/(?=<h1.*class=".*?_level[1-6]_page_.*)/i', $temp);
		}
		else
		{
			$contents = preg_split('/(?=<h[1-' . $this->menuLevels . '])/i', $temp);
		}
		
        array_shift($contents);

        foreach ($contents as $i => $content)
        {
            $data = !empty($page_data[$i])
                    ? $page_data[$i]
                    : array();
            $page = new Page($content, $this->menuLevels, $data, $this->rxScript);
            $this->mapPage($page);
        }

        $string = "<?php \n return " . var_export($this->pages, TRUE) . ";";

		if ($plugin_cf['subsitefuncs']['use_cache'] == 'true')
        {
			file_put_contents($this->cacheFile, $string);
		}
    }

    protected function mapPage(Page $page)
    {
        static $counter          = 1;
        static $ancestors        = array();
        $ancestors[$page->level] = $page->slug;
        $slug                    = implode($this->separator, array_slice($ancestors, 0, $page->level));
        $parent                  = implode($this->separator, array_slice($ancestors, 0, $page->level - 1));
        if (key_exists($slug, $this->pages))
        {
            $slug = $slug . "-$counter";
            $counter++;
            return $this->mapPage($page);
        } else
        {
            $counter = 1;
        }
        $this->pages[$slug] = array(
                        'level'       => $page->level,
                        'heading'     => $page->heading,
                        'content'     => $page->getEvaluated(FALSE),
                        'data'        => $page->data,
                        'isHidden'    => $page->isHidden(),
                        'isPublished' => $page->isPublished(),
                        'parent'      => $parent,
        );
    }

    function buildPageTree(array $pages, $parentSlug = '')
    {
        $branch = array();

        foreach ($pages as $slug => $page)
        {
            if ($page['parent'] == $parentSlug)
            {
                $page['children'] = $this->buildPageTree($pages, $slug);
                $branch[$slug] = $page;
            }
        }
        return $branch;
    }

    public function getPageTree($stopLevel = 3, $includeHiddenPages = FALSE)
    {
        $pageList = $this->getPageList($stopLevel, $includeHiddenPages);
        return $this->buildPageTree($pageList, '');
    }

    public function getPageList($stopLevel = 3, $includeHiddenPages = FALSE)
    {
        if (!(bool) $stopLevel || (int) $stopLevel > $this->menuLevels)
        {
            $stopLevel = $this->menuLevels;
        }

        $array = array();
        foreach ($this->pages as $slug => $page)
        {
            if ($page['isPublished'] === FALSE || (!$includeHiddenPages && $page['isHidden']))
            {
                continue;
            }

            if ($page['level'] <= $stopLevel)
            {
                $array[$slug] = array(
                                'href'       => $this->baseLink . '?' . $slug,
                                'level'      => $page['level'],
                                'heading'    => $page['heading'],
                                'lastUpdate' => $page['data']['last_edit'],
                                'parent'     => $page['parent'],
                );
            }
        }
        return $array;
    }

    public function search($words, $urlParam, $searchHiddenPages = FALSE)
    {
        $results = array();
        foreach ($this->pages as $slug => $page)
        {
            if ($page['isPublished'] === FALSE || (!$searchHiddenPages && $page['isHidden']))
            {
                continue;
            }
            $isMatch = TRUE;
            foreach ($words as $word)
            {
                $haystack = mb_strtolower($page['content'], 'utf-8');
                if (strpos($haystack, $word) === FALSE)
                {
                    $isMatch = FALSE;
                    break;
                }
            }

            if ($isMatch)
            {
                $results[] = array(
                                'href'    => $this->baseLink . '?' . $slug . $urlParam,
                                'heading' => $page['heading'],
								'class' => 'searchresult',
                                'children' => NULL,
                );
            }
        }
        return $results;
    }

    public function __get($property)
    {
        if (property_exists($this, $property))
        {
            return $this->$property;
        }
    }
}