<?php // utf-8 marker: äöü

/*
============================================================ 
CMSimple Plugin SubsiteFuncs
============================================================ 
Version:    SubsiteFuncs 2.5
Released:   2023-07
Copyright:  Gert Ebersbach - www.ge-webdesign.de
Authors:    Gert Ebersbach - www.ge-webdesign.de
            Martin Damken - www.zeichenkombinat.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
*/

class SsfPresenter
{

    protected $contentDirs       = array();
    protected $groups            = array();
    protected $config            = array();
    protected $sitesRegistry     = array();
    protected $menulevels        = 3;
    protected $separator         = '/';
    protected $rxScript          = '';
	protected $view              = '';
    protected $searchHiddenPages = TRUE;
    protected $hasLoaded         = '';
    public $currentSiteKey       = '';
    public $searchResultsCount   = 0;
    public $pageCount            = 0;

    public function __construct(array $pluginCfg, array $cf, array $subsitesData)
    {
        global $currentSubsiteFolderName;

		$this->view              = new SsfView(dirname(__FILE__) . '/../views');
        $this->config            = $pluginCfg;
        $this->rxScript          = $cf['scripting']['regexp'];
        $this->menulevels        = $cf['menu']['levels'];
        $this->separator         = $cf['uri']['seperator'];
        $this->searchHiddenPages = $pluginCfg['search_hidden_pages'] === 'true';

        // $key = trim(basename(dirname(filter_input(INPUT_SERVER, 'SCRIPT_NAME'))), '/\\');

		if($currentSubsiteFolderName != '')
		{
			$this->currentSiteKey = $currentSubsiteFolderName;
		}
		else
		{
			$this->currentSiteKey = 'main';
		}

        $this->contentDirs['main'] = CMSIMPLE_BASE;

        foreach (glob(CMSIMPLE_BASE . '*/cmsimplesubsite.htm') as $file)
        {
            $this->contentDirs[basename(dirname($file))] = dirname($file);
        }

        $this->initGroups();
        $this->registerDir('main', array('name' => $pluginCfg['mainsite_name']));

        foreach ($subsitesData as $key => $values)
        {
            if (key_exists($key, $this->contentDirs))
            {
                $this->registerDir($key, $values);
            }
        }

        if (filter_input(INPUT_GET, 'xmlsitemap') !== NULL)
        {
            $this->sendXmlSitemap();
        }
    }

    protected function loadSites()
    {
        if ($this->hasLoaded)
        {
            return;
        }
        foreach ($this->sitesRegistry as &$settings)
        {
            $settings['site'] = new Site($settings);
        }
        $this->hasLoaded = TRUE;
    }

    protected function initGroups()
    {

        if (!empty($this->config['groups']))
        {

            $groups     = explode('|', trim($this->config['groups']));
            $groupNames = explode('|', trim($this->config['groups_names']));
            foreach ($groups as $i => $group)
            {
                $this->groups[$group] = array(
                                'name'  => !empty($groupNames[$i])
                                        ? $groupNames[$i]
                                        : ucfirst($group),
                                'sites' => array());
            }
        }
    }

    protected function registerDir($key, $values)
    {

        $this->sitesRegistry[$key] = array(
                        'dir'               => $this->contentDirs[$key],
                        'isCurrent'         => $key === $this->currentSiteKey,
                        'name'              => isset($values['name'])
                                ? $values['name']
                                : ucfirst($key),
                        'group'             => isset($values['group'])
                                ? $values['group']
                                : FALSE,
                        'groupName'         => !empty($values['group']) && key_exists($values['group'], $this->groups) && !empty($this->groups[$values['group']]['name'])
                                ? $this->groups[$values['group']]['name']
                                : '',
                        'separator'         => $this->separator,
                        'menuLevels'        => $this->menulevels,
                        'rxScript'          => $this->rxScript,
                        'site'              => NULL,
                        'searchHiddenPages' => $this->searchHiddenPages,
        );
        if ($this->groups && isset($values['group']) && key_exists($values['group'], $this->groups))
        {
            $this->groups[$values['group']]['sites'][] = $key;
        }
    }

    /**
     *
     * @param bool $stopLevel
     * @param bool $includeHiddenPages
     * @return string
     */
    public function pageTree($stopLevel = 3, $includeHiddenPages = FALSE)
    {
        $this->loadSites();
        $html = '';
        foreach ($this->sitesRegistry as $key => $value)
        {
            $class = $value['isCurrent']
                    ? " current "
                    : '';
            $site  = $value['site'];
            $html .= $this->renderPageTree($site, $stopLevel, $includeHiddenPages, "$class $key");
        }

        $this->view
                ->setFile('container.php')
                ->setParam('class', $class)
                ->setParam('id', 'ssf_pagetree')
                ->setParam('output', $html, FALSE);

        return $this->view->render();
    }

    /**
     * returns a hierachicals list of pages
     *
     * @param int $stopLevel decides up to which level pages are shown
     * @param bool $includeHiddenPages whether to show hidden pages or not
     * @param bool $showHomepage whether to include the homepage or not
     * @return string
     */
    public function groupedPageTree($stopLevel = 3, $includeHiddenPages = FALSE, $showHomepage = FALSE)
    {
        $this->loadSites();
        $groups = '';
        $home   = '';
        foreach ($this->groups as $group)
        {
            $groups .= $this->renderGroupTree($group, $stopLevel, $includeHiddenPages);
        }

        if (!$groups)
        {
            return $this->pageTree($stopLevel, $includeHiddenPages);
        }

        if ($showHomepage)
        {
            $class = $this->currentSiteKey === 'main'
                    ? ' current '
                    : '';
            $site  = $this->sitesRegistry['main']['site'];
            $home .= $this->renderPageTree($site, $stopLevel, $includeHiddenPages, $class);
        }

        $this->view
                ->setFile('container.php')
                ->setParam('id', 'ssf_grouped_tree')
                ->setParam('class', 'ssf_grouped_tree')
                ->setParam('output', $home . $groups, FALSE);
        return $this->view->render();
    }

    protected function sendXmlSitemap()
    {
        $this->loadSites();
        //     $arrServer = filter_input_array(INPUT_SERVER);
        $arrServer = $_SERVER;
        $base      = !empty($arrServer['HTTPS']) && $arrServer['HTTPS'] == 'on'
                ? 'https://'
                : 'http://';
        $base .= $arrServer['HTTP_HOST'] . CMSIMPLE_ROOT;

        header('Content-type: application/xml');
        $xml = '<?xml version="1.0" encoding="UTF-8"?>' . "\n"
                . '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
        foreach ($this->getAllMenuLinks() as $link)
        {
            $lastMod = !empty($link['lastUpdate'])
                    ? date('Y-m-d', $link['lastUpdate'])
                    : FALSE;
            $xml .= "\t<url>\n";
            $xml .= "\t\t<loc>{$base}" . ltrim($link['href'], './') . "</loc>\n";

            if ($this->config['sitemap_changefreq'])
            {
                $xml .= "\t\t<changefreq>{$this->config['sitemap_changefreq']}</changefreq>";
            }

            if ($lastMod)
            {
                $xml .= "\t\t<lastmod>$lastMod</lastmod>";
            }
            $xml .= "\t</url>\n";
        }
        $xml .= "</urlset>";
        echo $xml;
        exit();
    }

    public function search()
    {
        global $s;
		$s = 0;
		$this->loadSites();
        $search   = mb_strtolower(filter_input(INPUT_GET, 'search'), 'utf-8');
        $words    = explode(' ', $search);
        $urlParam = '&amp;search=' . implode(',', $words);

        $html = '';

        foreach ($this->sitesRegistry as $value)
        {
            $site     = $value['site'];
            $pageList = $site->search($words, $urlParam, $this->searchHiddenPages);

            if (!$pageList)
            {
                continue;
            }

            $this->searchResultsCount += count($pageList);
            $html .= $this->renderResults($value['name'], $pageList, 'ssf_search');
        }
		$s = -1;

        return array('count' => $this->searchResultsCount, 'html' => $html);
    }

    protected function renderGroupTree(array $group, $stopLevel = 3, $includeHiddenPages = FALSE)
    {
        if (!$group['sites'])
        {
            return;
        }

        $class = in_array($this->currentSiteKey, $group['sites'])
                ? " current "
                : '';

        $results = '';
        foreach ($group['sites'] as $name)
        {
            $site    = $this->sitesRegistry[$name]['site'];
            $myclass = $this->sitesRegistry[$name]['isCurrent']
                    ? ' current '
                    : '';
            $results .= $this->renderPageTree($site, $stopLevel, $includeHiddenPages, $myclass);
        }

        $this->view
                ->setFile('subsiteresults.php')
                ->setParam('name', $group['name'])
                ->setParam('class', $class)
                ->setParam('results', $results, FALSE);
        return $this->view->render();
    }

    protected function getAllMenuLinks($stopLevel = 3, $includeHiddenPages = FALSE)
    {
        $map = array();
        foreach ($this->sitesRegistry as $site)
        {
            $values = array_values($site['site']->getPagelist($stopLevel, $includeHiddenPages));
            $map    = array_merge($map, $values);
        }
        return $map;
    }

    protected function renderPageTree(Site $site, $stopLevel = 3, $includeHiddenPages = FALSE, $cssClass=null)
    {
        $this->view
                ->setFile('linklist.php')
                ->setParam('pageList', $site->getPageTree($stopLevel, $includeHiddenPages), FALSE);
        $results = $this->view->render();

        return $this->view
                        ->setFile('subsiteresults.php')
                        ->setParam('name', $site->name)
                        ->setParam('class', $cssClass)
                        ->setParam('results', $results, FALSE)
                        ->render();
    }

    protected function renderResults($name, array $pageList, $cssClass)
    {
        $this->view
                ->setFile('linklist.php')
                ->setParam('pageList', $pageList, FALSE);
        $results = $this->view->render();

        return $this->view
                        ->setFile('subsiteresults.php')
                        ->setParam('name', $name)
                        ->setParam('class', $cssClass)
                        ->setParam('results', $results, FALSE)
                        ->render();
    }

    /**
     *
     * @param mixed $group may filter the pagelist by a certain group
     * @param bool $showMainsite whether to show the mainsite anyway
     * @param string $class
     * @return string
     */
    public function subsitesMenu($group = FALSE, $showMainsite = TRUE, $class = '')
    {
        $linkList = '';
        $pageList = array();
        #   var_dump($this->contentDirs, ($this->sitesRegistry));exit();
        foreach (array_keys($this->contentDirs) as $key)
        {
            if (!isset($this->sitesRegistry[$key]))
            {
                continue;
            }
            $site = $this->sitesRegistry[$key];
            $show = TRUE;
            if ($group && $group !== $site['group'])
            {
                $show = FALSE;
            }
            if ($key === 'main')
            {
                $show = $showMainsite;
            }
            if (!$show)
            {
                continue;
            }

            $pageList[] = array(
                            'href'    => $site['dir'],
                            'heading' => $site['name'],
                            'id'      => $key,
                            'class'   => $site['isCurrent']
                                    ? "current"
                                    : "",
            );
        }
        $this->view
                ->setFile('linklist.php')
                ->setParam('pageList', $pageList);
        $linkList .= $this->view->render();

        $this->view
                ->setFile('container.php')
                ->setParam('class', $class)
                ->setParam('output', $linkList, FALSE);
        return $this->view->render();
    }

    public function groupsMenu($showHomepage = TRUE, $userclass = '', $menuID = '')
    {
        $output = '';

        if ($showHomepage)
        {
            $site      = $this->sitesRegistry['main'];
            $siteClass = $site['isCurrent']
                    ? 'current '
                    : '';
            $this->view
                    ->setFile('subsiteresults.php')
                    ->setParam('name', '<a href="' . $site['dir'] . '">' . $site['name'] . '</a>', FALSE)
                    ->setParam('class', " $siteClass $userclass empty ");
            $output .= $this->view->render();
        }

        foreach ($this->groups as $group)
        {
            $name     = $group['name'];
            $pageList = array();

            $class = in_array($this->currentSiteKey, $group['sites'])
                    ? " current "
                    : '';

            foreach ($group['sites'] as $siteKey)
            {
                $site = $this->sitesRegistry[$siteKey];

                $siteClass = $site['isCurrent']
                        ? 'current '
                        : '';

                $pageList[] = array(
                                'href'    => $site['dir'],
                                'heading' => $site['name'],
                                'class'   => " $siteClass  $userclass ",
                );
            }

            $output .= $this->renderResults($name, $pageList, "$class $userclass");
        }
        $this->view
                ->setParam('id', $menuID)
                ->setParam('output', $output, FALSE);
        return $output;
    }
}
?>