<?php // utf-8 marker: äöü

/*
============================================================ 
CMSimple Plugin SubsiteFuncs
============================================================ 
Version:    SubsiteFuncs 2.5
Released:   2023-07
Copyright:  Gert Ebersbach - www.ge-webdesign.de
Authors:    Gert Ebersbach - www.ge-webdesign.de
            Martin Damken - www.zeichenkombinat.de
============================================================ 
License:
- free for noncommercial websites
- fee required for commercial websites
============================================================ 
*/

class Page
{
    protected $slug        = '';
    protected $content     = '';
    protected $heading     = '';
    protected $level       = 1;
    protected $data        = array();
    protected $evaluated   = '';
    protected $rxScript    = '';
    protected $rxFunctions = array(
                    '~{{{PLUGIN:(.*?)}}}~is',
                    '~{{{function:(.*?)}}}~is',
    );
    protected $showErrors  = TRUE;

    public function __construct($content, $stop, $data, $rxScript)
    {
		global $cf;
		
		$this->content = $content;
        $temp          = array();
		
		if($cf['use']['h1only_pagesplitting'] == 'true')
		{
			preg_match('~<h1.*class=".*_level([1-6])_page_.*".*>(.*)</h~isU', $content, $temp);
		}
		else
		{
			preg_match('~<h([1-' . $stop . ']).*>(.*)</h~isU', $content, $temp);
		}

        $this->level    = (int) $temp[1];
        $this->heading  = $temp[2];
        $this->slug     = uenc($temp[2]);
        $this->data     = $data;
        $this->rxScript = '~' . $rxScript . '~';
    }

    public function __get($name)
    {
        if (property_exists($this, $name))
        {
            return $this->$name;
        }

        if (key_exists($name, $this->data))
        {
            return $this->data['name'];
        }
    }

    public function isHidden()
    {
        $var = $this->data['linked_to_menu'];
        return (strlen($var) && !(bool) $var) || trim($this->getCMScript()) === 'hide';
    }

    public function isPublished()
    {
        $var = $this->data['published'];
        return (strlen($var) && !(bool) $var) || trim($this->getCMScript()) === 'remove'
                ? FALSE
                : TRUE;
    }

    public function getCMScript()
    {
        preg_match($this->rxScript, $this->content, $matches);
        if ($matches)
        {
            return $matches[1];
        }
        return '';
    }

    public function getEvaluated($showErrors = FALSE)
    {
        $this->showErrors = $showErrors;
        $this->evaluated  = $this->content;
        foreach ($this->rxFunctions as $pattern)
        {
            $this->evaluated = preg_replace_callback($pattern, array($this, 'evaluate'), $this->evaluated);
        }
        return $this->evaluated;
    }

    public function evaluate($match)
    {
        $call      = trim(str_replace(array('return'), '', $match[1]), ' ;');
        $functions = array();
        $vars      = array();
        $evaluate  = TRUE;
        $error     = '';

        preg_match_all('~([a-z_0-9]+)\(.*\)~i', $call, $functions);
        preg_match_all('~\$([a-z_0-9])+~i', $call, $vars);

        foreach ($functions[1] as $function)
        {
            if (!function_exists($function))
            {
                $error .= ' <span style="color:#5b0000; font-size:14px;">
	{{CALL TO:<span style="color:#c10000;">' . $call . '</span> FAILED}}</span> ';
                $evaluate = FALSE;
            }
        }

        if ($evaluate)
        {
            foreach ($vars[1] as $var)
            {
                global ${$var};
            }
            return eval("return $call;");
        }

        return $this->showErrors
                ? $error
                : '';
    }

}